/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.server.conversation;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.xadisk.bridge.server.conversation.HostedContext;

public class GlobalHostedContext
implements HostedContext {
    private final ConcurrentHashMap<Long, Object> remoteInvocationTargets = new ConcurrentHashMap();
    private final AtomicLong objectIdSequence = new AtomicLong(-System.currentTimeMillis());

    public long hostObject(Object target) {
        long objectId = this.objectIdSequence.decrementAndGet();
        this.remoteInvocationTargets.put(objectId, target);
        return objectId;
    }

    public void deHostObjectWithId(long objectId) {
        this.remoteInvocationTargets.remove(objectId);
    }

    public long deHostObject(Object target) {
        Long objectId = null;
        Set<Map.Entry<Long, Object>> entries = this.remoteInvocationTargets.entrySet();
        for (Map.Entry<Long, Object> entry : entries) {
            if (!entry.getValue().equals(target)) continue;
            objectId = entry.getKey();
            break;
        }
        if (objectId != null) {
            this.remoteInvocationTargets.remove(objectId);
            return objectId;
        }
        return 1L;
    }

    public Object getHostedObjectWithId(long objectId) {
        return this.remoteInvocationTargets.get(objectId);
    }
}

