/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.workers;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.spi.work.Work;

public abstract class TimedWorker
implements Work {
    private final int frequency;
    private final ReentrantLock wakeUpAndDieAlarm = new ReentrantLock(false);
    private final Condition hasBeenReleased = this.wakeUpAndDieAlarm.newCondition();
    private boolean released = false;

    TimedWorker(int frequency) {
        this.frequency = frequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            this.wakeUpAndDieAlarm.lockInterruptibly();
            this.released = true;
            this.hasBeenReleased.signal();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.wakeUpAndDieAlarm.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.released) {
            this.doWorkOnce();
            try {
                this.wakeUpAndDieAlarm.lockInterruptibly();
                this.hasBeenReleased.await((long)this.frequency * 1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.wakeUpAndDieAlarm.unlock();
            }
        }
    }

    abstract void doWorkOnce();

    int getFrequency() {
        return this.frequency;
    }
}

