/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class Mutation<E, K> {
    private List<E> additions;
    private List<K> deletions;

    public Mutation(List<E> additions, List<K> deletions) {
        Preconditions.checkNotNull(additions);
        Preconditions.checkNotNull(deletions);
        this.additions = additions.isEmpty() ? null : Lists.newArrayList(additions);
        this.deletions = deletions.isEmpty() ? null : Lists.newArrayList(deletions);
    }

    public Mutation() {
        this.additions = null;
        this.deletions = null;
    }

    public boolean hasAdditions() {
        return this.additions != null && !this.additions.isEmpty();
    }

    public boolean hasDeletions() {
        return this.deletions != null && !this.deletions.isEmpty();
    }

    public List<E> getAdditions() {
        if (this.additions == null) {
            return ImmutableList.of();
        }
        return this.additions;
    }

    public List<K> getDeletions() {
        if (this.deletions == null) {
            return ImmutableList.of();
        }
        return this.deletions;
    }

    public void addition(E entry) {
        if (this.additions == null) {
            this.additions = new ArrayList();
        }
        this.additions.add(entry);
    }

    public void deletion(K key) {
        if (this.deletions == null) {
            this.deletions = new ArrayList<K>();
        }
        this.deletions.add(key);
    }

    public void merge(Mutation<E, K> m) {
        Preconditions.checkNotNull(m);
        if (null != m.additions) {
            if (null == this.additions) {
                this.additions = m.additions;
            } else {
                this.additions.addAll(m.additions);
            }
        }
        if (null != m.deletions) {
            if (null == this.deletions) {
                this.deletions = m.deletions;
            } else {
                this.deletions.addAll(m.deletions);
            }
        }
    }

    public boolean isEmpty() {
        return this.getTotalMutations() == 0;
    }

    public int getTotalMutations() {
        return (this.additions == null ? 0 : this.additions.size()) + (this.deletions == null ? 0 : this.deletions.size());
    }

    public <V> void consolidate(Function<E, V> convertAdds, Function<K, V> convertDels) {
        if (this.hasDeletions() && this.hasAdditions()) {
            HashSet adds = Sets.newHashSet((Iterable)Iterables.transform(this.additions, convertAdds));
            Iterator<K> iter = this.deletions.iterator();
            while (iter.hasNext()) {
                if (!adds.contains(convertDels.apply(iter.next()))) continue;
                iter.remove();
            }
        }
    }

    public abstract void consolidate();

    public <V> boolean isConsolidated(Function<E, V> convertAdds, Function<K, V> convertDels) {
        int delBefore = this.getDeletions().size();
        this.consolidate(convertAdds, convertDels);
        return this.getDeletions().size() == delBefore;
    }

    public abstract boolean isConsolidated();
}

