/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.diskstorage.configuration.AbstractConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MixedConfiguration
extends AbstractConfiguration {
    private final ReadConfiguration global;
    private final ReadConfiguration local;

    public MixedConfiguration(ConfigNamespace root, ReadConfiguration global, ReadConfiguration local) {
        super(root);
        Preconditions.checkNotNull((Object)global);
        Preconditions.checkNotNull((Object)local);
        this.global = global;
        this.local = local;
    }

    @Override
    public boolean has(ConfigOption option, String ... umbrellaElements) {
        String key = super.getPath(option, umbrellaElements);
        if (option.isLocal() && this.local.get(key, option.getDatatype()) != null) {
            return true;
        }
        return option.isGlobal() && this.global.get(key, option.getDatatype()) != null;
    }

    @Override
    public <O> O get(ConfigOption<O> option, String ... umbrellaElements) {
        String key = super.getPath(option, umbrellaElements);
        Object result = null;
        if (option.isLocal()) {
            result = this.local.get(key, option.getDatatype());
        }
        if (result == null && option.isGlobal()) {
            result = this.global.get(key, option.getDatatype());
        }
        return option.get(result);
    }

    @Override
    public Set<String> getContainedNamespaces(ConfigNamespace umbrella, String ... umbrellaElements) {
        HashSet result = Sets.newHashSet();
        for (ReadConfiguration config : new ReadConfiguration[]{this.global, this.local}) {
            result.addAll(super.getContainedNamespaces(config, umbrella, umbrellaElements));
        }
        return result;
    }

    @Override
    public Map<String, Object> getSubset(ConfigNamespace umbrella, String ... umbrellaElements) {
        HashMap result = Maps.newHashMap();
        for (ReadConfiguration config : new ReadConfiguration[]{this.global, this.local}) {
            result.putAll(super.getSubset(config, umbrella, umbrellaElements));
        }
        return result;
    }

    @Override
    public Configuration restrictTo(String ... umbrellaElements) {
        return MixedConfiguration.restrictTo(this, umbrellaElements);
    }

    @Override
    public void close() {
        this.global.close();
        this.local.close();
    }
}

