/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.schema.Mapping;
import java.util.Arrays;
import java.util.Set;

public class IndexFeatures {
    private final boolean supportsDocumentTTL;
    private final Mapping defaultStringMapping;
    private final ImmutableSet<Mapping> supportedStringMappings;

    public IndexFeatures(boolean supportsDocumentTTL, Mapping defaultMap, ImmutableSet<Mapping> supportedMap) {
        Preconditions.checkArgument((defaultMap != null || defaultMap != Mapping.DEFAULT ? 1 : 0) != 0);
        Preconditions.checkArgument((supportedMap != null && !supportedMap.isEmpty() && supportedMap.contains((Object)defaultMap) ? 1 : 0) != 0);
        this.supportsDocumentTTL = supportsDocumentTTL;
        this.defaultStringMapping = defaultMap;
        this.supportedStringMappings = supportedMap;
    }

    public boolean supportsDocumentTTL() {
        return this.supportsDocumentTTL;
    }

    public Mapping getDefaultStringMapping() {
        return this.defaultStringMapping;
    }

    public boolean supportsStringMapping(Mapping map) {
        return this.supportedStringMappings.contains((Object)map);
    }

    public static class Builder {
        private boolean supportsDocumentTTL = false;
        private Mapping defaultStringMapping = Mapping.TEXT;
        private Set<Mapping> supportedMappings = Sets.newHashSet();

        public Builder supportsDocumentTTL() {
            this.supportsDocumentTTL = true;
            return this;
        }

        public Builder setDefaultStringMapping(Mapping map) {
            this.defaultStringMapping = map;
            return this;
        }

        public Builder supportedStringMappings(Mapping ... maps) {
            this.supportedMappings.addAll(Arrays.asList(maps));
            return this;
        }

        public IndexFeatures build() {
            return new IndexFeatures(this.supportsDocumentTTL, this.defaultStringMapping, (ImmutableSet<Mapping>)ImmutableSet.copyOf(this.supportedMappings));
        }
    }
}

