/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query;

import com.thinkaurelius.titan.core.TitanElement;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResultSetIterator<R extends TitanElement>
implements Iterator<R> {
    private final Iterator<R> iter;
    private final int limit;
    private R current;
    private R next;
    private int count;

    public ResultSetIterator(Iterator<R> inner, int limit) {
        this.iter = inner;
        this.limit = limit;
        this.count = 0;
        this.current = null;
        this.next = this.nextInternal();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    private R nextInternal() {
        TitanElement r = null;
        if (this.count < this.limit && this.iter.hasNext()) {
            r = (TitanElement)this.iter.next();
        }
        return (R)r;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        ++this.count;
        this.next = this.nextInternal();
        return this.current;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new UnsupportedOperationException();
        }
        this.current.remove();
    }

    public static <R extends TitanElement> Iterable<R> wrap(final Iterable<R> inner, final int limit) {
        return new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return new ResultSetIterator(inner.iterator(), limit);
            }
        };
    }
}

