/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.archetype;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.lucene.search.Query;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.FlatSearchRequest;
import org.apache.maven.index.FlatSearchResponse;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchetypeDataSource
implements ArchetypeDataSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Indexer indexer;

    protected Logger getLogger() {
        return this.logger;
    }

    @Inject
    protected AbstractArchetypeDataSource(Indexer indexer) {
        this.indexer = indexer;
    }

    public ArchetypeCatalog getArchetypeCatalog(Properties properties) throws ArchetypeDataSourceException {
        ArchetypeCatalog catalog = new ArchetypeCatalog();
        try {
            Map<String, String> repositories = this.getRepositoryMap();
            Query pq = this.indexer.constructQuery(MAVEN.PACKAGING, new SourcedSearchExpression("maven-archetype"));
            FlatSearchRequest searchRequest = new FlatSearchRequest(pq);
            searchRequest.setContexts(this.getIndexingContexts());
            FlatSearchResponse searchResponse = this.indexer.searchFlat(searchRequest);
            for (ArtifactInfo info : searchResponse.getResults()) {
                Archetype archetype = new Archetype();
                archetype.setGroupId(info.getGroupId());
                archetype.setArtifactId(info.getArtifactId());
                archetype.setVersion(info.getVersion());
                archetype.setDescription(info.getDescription());
                archetype.setRepository(repositories.get(info.getRepository()));
                catalog.addArchetype(archetype);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to retrieve archetypes", (Throwable)ex);
        }
        return catalog;
    }

    private Map<String, String> getRepositoryMap() {
        HashMap<String, String> repositories = new HashMap<String, String>();
        for (IndexingContext context : this.getIndexingContexts()) {
            String repositoryUrl = context.getRepositoryUrl();
            if (repositoryUrl == null) continue;
            repositories.put(context.getId(), repositoryUrl);
        }
        return repositories;
    }

    public void updateCatalog(Properties properties, Archetype archetype) {
    }

    protected abstract List<IndexingContext> getIndexingContexts();
}

