/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import java.io.PrintStream;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;
import org.jboss.forge.addon.maven.projects.archetype.ui.AbstractArchetypeCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ArchetypeListCommand
extends AbstractArchetypeCommand {
    private UIInput<String> named;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.named = (UIInput)((UIInput)factory.createInput("named", String.class).setLabel("Archetype catalog Name")).setDescription("The archetype catalog name to be used");
        builder.add(this.named);
    }

    public boolean isEnabled(UIContext context) {
        return !context.getProvider().isGUI();
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Archetype: List").category(Categories.create((String[])new String[]{"Maven"})).description("Lists the registered archetype catalogs from the Forge configuration file");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        block3: {
            PrintStream out;
            block2: {
                ArchetypeCatalog archetypeCatalog;
                UIOutput output = context.getUIContext().getProvider().getOutput();
                out = output.out();
                if (!this.named.hasValue()) break block2;
                ArchetypeCatalogFactory archetypeCatalogFactory = this.getArchetypeCatalogFactoryRegistry().getArchetypeCatalogFactory((String)this.named.getValue());
                if (archetypeCatalogFactory == null || (archetypeCatalog = archetypeCatalogFactory.getArchetypeCatalog()) == null) break block3;
                for (Archetype archetype : archetypeCatalog.getArchetypes()) {
                    out.println(archetype);
                }
                break block3;
            }
            for (ArchetypeCatalogFactory factory : this.getArchetypeCatalogFactoryRegistry().getArchetypeCatalogFactories()) {
                String key = factory.getName();
                String catalog = factory.toString();
                out.println(key + " = " + catalog);
            }
        }
        return Results.success();
    }
}

