/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.oupls.sail;

import com.tinkerpop.blueprints.CloseableIterable;
import java.util.Iterator;
import java.util.List;

class FilteredIterator<T>
implements CloseableIterable<T>,
Iterator<T> {
    private final Iterator<T> baseIterator;
    private final Criterion<T> criterion;
    private T cur;

    public FilteredIterator(Iterable<T> base, Criterion<T> criterion) {
        this.baseIterator = base.iterator();
        this.criterion = criterion;
        this.advanceToNext();
    }

    @Override
    public boolean hasNext() {
        return null != this.cur;
    }

    @Override
    public T next() {
        T t = this.cur;
        this.advanceToNext();
        return t;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advanceToNext() {
        while (this.baseIterator.hasNext()) {
            this.cur = this.baseIterator.next();
            if (!this.criterion.fulfilledBy(this.cur)) continue;
            return;
        }
        this.cur = null;
    }

    public void close() {
    }

    public Iterator<T> iterator() {
        return this;
    }

    public static class CompoundCriterion<T>
    implements Criterion<T> {
        private final List<Criterion<T>> criteria;

        public CompoundCriterion(List<Criterion<T>> criteria) {
            this.criteria = criteria;
        }

        @Override
        public boolean fulfilledBy(T t) {
            for (Criterion<T> c : this.criteria) {
                if (c.fulfilledBy(t)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface Criterion<T> {
        public boolean fulfilledBy(T var1);
    }
}

