/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanException;
import org.apache.commons.lang.StringUtils;

public class ResourceUnavailableException
extends TitanException {
    private static final long serialVersionUID = 482890657293484420L;

    public ResourceUnavailableException(String msg) {
        super(msg);
    }

    public ResourceUnavailableException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public ResourceUnavailableException(Throwable cause) {
        this("Attempting to access unavailable resource", cause);
    }

    public static final void verifyOpen(boolean isOpen, String resourceName, String ... resourceIdentifiers) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)resourceName));
        if (!isOpen) {
            StringBuilder msg = new StringBuilder();
            msg.append(resourceName).append(" ");
            if (resourceIdentifiers != null && resourceIdentifiers.length > 0) {
                msg.append("[");
                for (int i = 0; i < resourceIdentifiers.length; ++i) {
                    if (i > 0) {
                        msg.append(",");
                    }
                    msg.append(resourceIdentifiers[i]);
                }
                msg.append("] ");
            }
            msg.append("has been closed");
            throw new ResourceUnavailableException(msg.toString());
        }
    }
}

