/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.schema;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.graphdb.schema.EdgeLabelDefinition;
import com.thinkaurelius.titan.graphdb.schema.PropertyKeyDefinition;
import com.thinkaurelius.titan.graphdb.schema.RelationTypeDefinition;
import com.thinkaurelius.titan.graphdb.schema.SchemaProvider;
import com.thinkaurelius.titan.graphdb.schema.VertexLabelDefinition;
import java.util.Map;

public class SchemaContainer
implements SchemaProvider {
    private final Map<String, VertexLabelDefinition> vertexLabels = Maps.newHashMap();
    private final Map<String, RelationTypeDefinition> relationTypes = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaContainer(TitanGraph graph) {
        TitanManagement mgmt = graph.getManagementSystem();
        try {
            for (VertexLabel vl : mgmt.getVertexLabels()) {
                VertexLabelDefinition vld = new VertexLabelDefinition(vl);
                this.vertexLabels.put(vld.getName(), vld);
            }
            for (EdgeLabel el : mgmt.getRelationTypes(EdgeLabel.class)) {
                EdgeLabelDefinition eld = new EdgeLabelDefinition(el);
                this.relationTypes.put(eld.getName(), eld);
            }
            for (PropertyKey pk : mgmt.getRelationTypes(PropertyKey.class)) {
                PropertyKeyDefinition pkd = new PropertyKeyDefinition(pk);
                this.relationTypes.put(pkd.getName(), pkd);
            }
        }
        finally {
            mgmt.rollback();
        }
    }

    public Iterable<VertexLabelDefinition> getVertexLabels() {
        return this.vertexLabels.values();
    }

    @Override
    public VertexLabelDefinition getVertexLabel(String name) {
        return this.vertexLabels.get(name);
    }

    public boolean containsVertexLabel(String name) {
        return this.getVertexLabel(name) != null;
    }

    public Iterable<PropertyKeyDefinition> getPropertyKeys() {
        return Iterables.filter(this.relationTypes.values(), PropertyKeyDefinition.class);
    }

    public Iterable<EdgeLabelDefinition> getEdgeLabels() {
        return Iterables.filter(this.relationTypes.values(), EdgeLabelDefinition.class);
    }

    @Override
    public RelationTypeDefinition getRelationType(String name) {
        return this.relationTypes.get(name);
    }

    public boolean containsRelationType(String name) {
        return this.getRelationType(name) != null;
    }

    @Override
    public EdgeLabelDefinition getEdgeLabel(String name) {
        RelationTypeDefinition def = this.getRelationType(name);
        if (def != null && !(def instanceof EdgeLabelDefinition)) {
            throw new IllegalArgumentException("Not an edge label but property key: " + name);
        }
        return (EdgeLabelDefinition)def;
    }

    @Override
    public PropertyKeyDefinition getPropertyKey(String name) {
        RelationTypeDefinition def = this.getRelationType(name);
        if (def != null && !(def instanceof PropertyKeyDefinition)) {
            throw new IllegalArgumentException("Not a property key but edge label: " + name);
        }
        return (PropertyKeyDefinition)def;
    }
}

