/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.util.Selections;
import org.jboss.forge.furnace.spi.ListenerRegistration;

public abstract class AbstractUIContext
implements UIContext {
    private final Map<Object, Object> map;
    private UISelection<?> selection;
    private final Set<CommandExecutionListener> listeners = new LinkedHashSet<CommandExecutionListener>();

    public AbstractUIContext() {
        this.map = new HashMap<Object, Object>(System.getProperties());
    }

    @Override
    public <SELECTIONTYPE> UISelection<SELECTIONTYPE> getSelection() {
        return this.selection != null ? this.selection : this.getInitialSelection();
    }

    @Override
    public <SELECTIONTYPE> void setSelection(SELECTIONTYPE selection) {
        this.selection = selection == null ? null : (selection instanceof UISelection ? (UISelection<Object>)selection : Selections.from(selection));
    }

    @Override
    public <SELECTIONTYPE> void setSelection(UISelection<SELECTIONTYPE> selection) {
        this.selection = selection;
    }

    @Override
    public Map<Object, Object> getAttributeMap() {
        return this.map;
    }

    @Override
    public UIProvider getProvider() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void close() {
        this.clearListeners();
    }

    @Override
    public ListenerRegistration<CommandExecutionListener> addCommandExecutionListener(final CommandExecutionListener listener) {
        this.listeners.add(listener);
        return new ListenerRegistration<CommandExecutionListener>(){

            public CommandExecutionListener removeListener() {
                AbstractUIContext.this.listeners.remove(listener);
                return listener;
            }
        };
    }

    @Override
    public Set<CommandExecutionListener> getListeners() {
        return Collections.unmodifiableSet(this.listeners);
    }

    public void clearListeners() {
        this.listeners.clear();
    }
}

