/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.furnace.util.Assert;

public class Categories {
    private static final String DEFAULT = "Uncategorized";

    public static UICategory createDefault() {
        return Categories.create(DEFAULT);
    }

    public static UICategory create(UICategory category, String ... categories) {
        Assert.notNull((Object)category, (String)"Parent UICategory must not be null.");
        Assert.notNull((Object)categories, (String)"Sub categories must not be null.");
        ArrayList<String> args = new ArrayList<String>();
        args.add(category.getName());
        args.addAll(Arrays.asList(categories));
        return Categories.create(args.toArray(new String[args.size()]));
    }

    public static UICategory create(String ... categories) {
        if (categories == null || categories.length == 0) {
            return new UICategoryImpl(DEFAULT, null);
        }
        if (categories.length == 1) {
            return new UICategoryImpl(categories[0], null);
        }
        return new UICategoryImpl(categories[0], Categories.create(Arrays.copyOfRange(categories, 1, categories.length)));
    }

    public static String getCategoryName(UICategory category) {
        return category == null ? DEFAULT : category.toString();
    }

    private static class UICategoryImpl
    implements UICategory {
        private String name;
        private UICategory subCategory;

        public UICategoryImpl(String name, UICategory subCategory) {
            Assert.notNull((Object)name, (String)"Name must not be null.");
            this.name = name;
            this.subCategory = subCategory;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public UICategory getSubCategory() {
            return this.subCategory;
        }

        public String toString() {
            return this.getName() + (this.getSubCategory() != null ? "/" + this.getSubCategory() : "");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.subCategory == null ? 0 : this.subCategory.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UICategoryImpl other = (UICategoryImpl)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.subCategory == null ? other.subCategory != null : !this.subCategory.equals(other.subCategory));
        }
    }
}

