/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONObjectDeserializer;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONArrayDeserializer
extends StdDeserializer<JSONArray> {
    private static final long serialVersionUID = 1L;
    public static final JSONArrayDeserializer instance = new JSONArrayDeserializer();

    public JSONArrayDeserializer() {
        super(JSONArray.class);
    }

    public JSONArray deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken;
        JSONArray jSONArray = new JSONArray();
        block11: while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
            switch (jsonToken) {
                case START_ARRAY: {
                    jSONArray.put((Object)this.deserialize(jsonParser, deserializationContext));
                    continue block11;
                }
                case START_OBJECT: {
                    jSONArray.put((Object)JSONObjectDeserializer.instance.deserialize(jsonParser, deserializationContext));
                    continue block11;
                }
                case VALUE_STRING: {
                    jSONArray.put((Object)jsonParser.getText());
                    continue block11;
                }
                case VALUE_NULL: {
                    jSONArray.put(JSONObject.NULL);
                    continue block11;
                }
                case VALUE_TRUE: {
                    jSONArray.put((Object)Boolean.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    jSONArray.put((Object)Boolean.FALSE);
                    continue block11;
                }
                case VALUE_NUMBER_INT: {
                    jSONArray.put((Object)jsonParser.getNumberValue());
                    continue block11;
                }
                case VALUE_NUMBER_FLOAT: {
                    jSONArray.put((Object)jsonParser.getNumberValue());
                    continue block11;
                }
                case VALUE_EMBEDDED_OBJECT: {
                    jSONArray.put(jsonParser.getEmbeddedObject());
                    continue block11;
                }
            }
            throw deserializationContext.mappingException("Unrecognized or unsupported JsonToken type: " + jsonToken);
        }
        return jSONArray;
    }
}

