/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util.ldiff;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.util.ldiff.Block;
import com.sleepycat.je.rep.util.ldiff.MismatchedRegion;
import com.sleepycat.je.rep.util.ldiff.Record;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class Protocol
extends BinaryProtocol {
    public static final int VERSION = 2;
    public static final BinaryProtocol.MessageOp DB_BLOCKS = new BinaryProtocol.MessageOp(1, DbBlocks.class);
    public static final BinaryProtocol.MessageOp DB_MISMATCH = new BinaryProtocol.MessageOp(2, DbMismatch.class);
    public static final BinaryProtocol.MessageOp BLOCK_LIST_START = new BinaryProtocol.MessageOp(3, BlockListStart.class);
    public static final BinaryProtocol.MessageOp BLOCK_INFO = new BinaryProtocol.MessageOp(4, BlockInfo.class);
    public static final BinaryProtocol.MessageOp BLOCK_LIST_END = new BinaryProtocol.MessageOp(5, BlockListEnd.class);
    public static final BinaryProtocol.MessageOp ENV_DIFF = new BinaryProtocol.MessageOp(6, EnvDiff.class);
    public static final BinaryProtocol.MessageOp ENV_INFO = new BinaryProtocol.MessageOp(7, EnvInfo.class);
    public static final BinaryProtocol.MessageOp REMOTE_DIFF_REQUEST = new BinaryProtocol.MessageOp(8, RemoteDiffRequest.class);
    public static final BinaryProtocol.MessageOp REMOTE_RECORD = new BinaryProtocol.MessageOp(9, RemoteRecord.class);
    public static final BinaryProtocol.MessageOp DIFF_AREA_START = new BinaryProtocol.MessageOp(10, DiffAreaStart.class);
    public static final BinaryProtocol.MessageOp DIFF_AREA_END = new BinaryProtocol.MessageOp(11, DiffAreaEnd.class);
    public static final BinaryProtocol.MessageOp DONE = new BinaryProtocol.MessageOp(12, Done.class);
    public static final BinaryProtocol.MessageOp ERROR = new BinaryProtocol.MessageOp(13, Error.class);

    public Protocol(NameIdPair nameIdPair, EnvironmentImpl envImpl) {
        super(nameIdPair, 2, 2, envImpl);
        this.initializeMessageOps(new BinaryProtocol.MessageOp[]{DB_BLOCKS, DB_MISMATCH, BLOCK_LIST_START, BLOCK_INFO, BLOCK_LIST_END, ENV_DIFF, ENV_INFO, REMOTE_DIFF_REQUEST, REMOTE_RECORD, DIFF_AREA_START, DIFF_AREA_END, DONE, ERROR});
    }

    public class Error
    extends BinaryProtocol.RejectMessage {
        public Error(String message) {
            super((BinaryProtocol)Protocol.this, message);
        }

        public Error(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return ERROR;
        }
    }

    public class Done
    extends BinaryProtocol.SimpleMessage {
        public Done() {
            super(Protocol.this);
        }

        public Done(ByteBuffer buffer) {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return DONE;
        }
    }

    public class DiffAreaEnd
    extends BinaryProtocol.SimpleMessage {
        public DiffAreaEnd() {
            super(Protocol.this);
        }

        public DiffAreaEnd(ByteBuffer buffer) {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return DIFF_AREA_END;
        }
    }

    public class DiffAreaStart
    extends BinaryProtocol.SimpleMessage {
        public DiffAreaStart() {
            super(Protocol.this);
        }

        public DiffAreaStart(ByteBuffer buffer) {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return DIFF_AREA_START;
        }
    }

    public class RemoteRecord
    extends BinaryProtocol.SimpleMessage {
        final byte[] key;
        final byte[] data;
        final VLSN vlsn;

        public RemoteRecord(Record record) {
            super(Protocol.this);
            this.key = record.getKey();
            this.data = record.getData();
            this.vlsn = record.getVLSN();
        }

        public RemoteRecord(ByteBuffer buffer) {
            super(Protocol.this);
            this.key = this.getByteArray(buffer);
            this.data = this.getByteArray(buffer);
            this.vlsn = this.getVLSN(buffer);
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.key, this.data, this.vlsn);
        }

        public BinaryProtocol.MessageOp getOp() {
            return REMOTE_RECORD;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getData() {
            return this.data;
        }

        public VLSN getVLSN() {
            return this.vlsn;
        }
    }

    public class RemoteDiffRequest
    extends BinaryProtocol.SimpleMessage {
        final byte[] key;
        final byte[] data;
        final long diffSize;

        public RemoteDiffRequest(MismatchedRegion region) {
            super(Protocol.this);
            this.key = region.getRemoteBeginKey();
            this.data = region.getRemoteBeginData();
            this.diffSize = region.getRemoteDiffSize();
        }

        public RemoteDiffRequest(ByteBuffer buffer) {
            super(Protocol.this);
            this.key = this.getByteArray(buffer);
            this.data = this.getByteArray(buffer);
            this.diffSize = LogUtils.readInt(buffer);
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.key, this.data, this.diffSize);
        }

        public BinaryProtocol.MessageOp getOp() {
            return REMOTE_DIFF_REQUEST;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getData() {
            return this.data;
        }

        public long getDiffSize() {
            return this.diffSize;
        }
    }

    public class EnvInfo
    extends BinaryProtocol.SimpleMessage {
        final int numDBs;

        public EnvInfo(int numberOfDbs) {
            super(Protocol.this);
            this.numDBs = numberOfDbs;
        }

        public EnvInfo(ByteBuffer buffer) {
            super(Protocol.this);
            this.numDBs = LogUtils.readInt(buffer);
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.numDBs);
        }

        public BinaryProtocol.MessageOp getOp() {
            return ENV_INFO;
        }

        public int getNumberOfDBs() {
            return this.numDBs;
        }
    }

    public class EnvDiff
    extends BinaryProtocol.SimpleMessage {
        public EnvDiff() {
            super(Protocol.this);
        }

        public EnvDiff(ByteBuffer buffer) {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return ENV_DIFF;
        }
    }

    public class BlockInfo
    extends BinaryProtocol.SimpleMessage {
        final Block block;

        public BlockInfo(Block block) {
            super(Protocol.this);
            this.block = block;
        }

        public BlockInfo(ByteBuffer buffer) {
            super(Protocol.this);
            this.block = new Block(LogUtils.readInt(buffer));
            this.block.setBeginKey(this.getByteArray(buffer));
            this.block.setBeginData(this.getByteArray(buffer));
            this.block.setMd5Hash(this.getByteArray(buffer));
            this.block.setRollingChksum(LogUtils.readLong(buffer));
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.block.getBlockId(), this.block.getBeginKey(), this.block.getBeginData(), this.block.getMd5Hash(), this.block.getRollingChksum());
        }

        public BinaryProtocol.MessageOp getOp() {
            return BLOCK_INFO;
        }

        public Block getBlock() {
            return this.block;
        }
    }

    public class BlockListEnd
    extends BinaryProtocol.SimpleMessage {
        public BlockListEnd() {
            super(Protocol.this);
        }

        public BlockListEnd(ByteBuffer buffer) {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return BLOCK_LIST_END;
        }
    }

    public class BlockListStart
    extends BinaryProtocol.SimpleMessage {
        public BlockListStart() {
            super(Protocol.this);
        }

        public BlockListStart(ByteBuffer buffer) {
            super(Protocol.this);
        }

        public BinaryProtocol.MessageOp getOp() {
            return BLOCK_LIST_START;
        }
    }

    public class DbMismatch
    extends BinaryProtocol.RejectMessage {
        public DbMismatch(String message) {
            super((BinaryProtocol)Protocol.this, message);
        }

        public DbMismatch(ByteBuffer buffer) {
            super((BinaryProtocol)Protocol.this, buffer);
        }

        public BinaryProtocol.MessageOp getOp() {
            return DB_MISMATCH;
        }
    }

    public class DbBlocks
    extends BinaryProtocol.SimpleMessage {
        final String dbName;
        final int blockSize;

        public DbBlocks(String dbName, int blockSize) {
            super(Protocol.this);
            this.dbName = dbName;
            this.blockSize = blockSize;
        }

        public DbBlocks(ByteBuffer buffer) {
            super(Protocol.this);
            this.dbName = Protocol.this.getString(buffer);
            this.blockSize = LogUtils.readInt(buffer);
        }

        public ByteBuffer wireFormat() {
            return this.wireFormat(this.dbName, this.blockSize);
        }

        public BinaryProtocol.MessageOp getOp() {
            return DB_BLOCKS;
        }

        public String getDbName() {
            return this.dbName;
        }

        public int getBlockSize() {
            return this.blockSize;
        }
    }
}

