/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.rep.impl.RepGroupDB;
import com.sleepycat.je.rep.vlsn.VLSNBucket;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class DbStreamVerify {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbStreamVerify.class) + "\n" + " -h <dir>      # environment home directory\n" + " -s <hex>      # start file\n" + " -e <hex>      # end file\n" + " -verifyStream # check that replication stream is ascending\n" + " -dumpVLSN     # scan log file for log entries that make up the" + " VLSN index, don't run verify.\n" + " -dumpRepGroup # scan log file for log entries that make up the" + " rep group db, don't run verify.\n" + " -i            # show invisible. If true, print invisible entries" + " when running verify mode.\n" + " -v            # verbose\n";
    private File envHome = null;
    private boolean showInvisible = false;
    private boolean verbose = false;
    private boolean vlsnDump = false;
    private boolean repGroupDump = false;
    private boolean verifyStream = false;
    private long startLsn = -1L;
    private long endLsn = -1L;
    private final PrintStream out;

    public static void main(String[] argv) throws Exception {
        DbStreamVerify verify = new DbStreamVerify(System.out);
        verify.parseArgs(argv);
        try {
            verify.run();
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private DbStreamVerify(PrintStream out) {
        this.out = out;
    }

    private void printUsage(String msg) {
        if (msg != null) {
            this.out.println(msg);
        }
        this.out.println(USAGE);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-i")) {
                this.showInvisible = true;
                continue;
            }
            if (thisArg.equals("-v")) {
                this.verbose = true;
                continue;
            }
            if (thisArg.equals("-verifyStream")) {
                this.verifyStream = true;
                continue;
            }
            if (thisArg.equals("-dumpVLSN")) {
                this.vlsnDump = true;
                continue;
            }
            if (thisArg.equals("-dumpRepGroup")) {
                this.repGroupDump = true;
                continue;
            }
            if (thisArg.equals("-s")) {
                this.startLsn = CmdUtil.readLsn(CmdUtil.getArg(argv, argc++));
                continue;
            }
            if (thisArg.equals("-e")) {
                this.endLsn = CmdUtil.readLsn(CmdUtil.getArg(argv, argc++));
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (!(this.vlsnDump || this.repGroupDump || this.verifyStream)) {
            this.printUsage("Must specify -dumpVLSN, -dumpRepGroup or -verifyStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        env = new Environment(this.envHome, envConfig);
        envImpl = DbInternal.getEnvironmentImpl(env);
        try {
            block13: {
                block15: {
                    block14: {
                        block12: {
                            if (!this.vlsnDump) break block12;
                            this.out.println("Dump VLSNIndex LNs");
                            reader /* !! */  = new VLSNIndexReader(env, this.out, this.startLsn, this.endLsn);
                            break block13;
                        }
                        if (!this.repGroupDump) break block14;
                        this.out.println("Dump RepGroup LNs");
                        reader /* !! */  = new RepGroupReader(env, this.out, this.startLsn, this.endLsn);
                        break block13;
                    }
                    if (this.verifyStream) break block15;
                    this.out.println("No action specified.");
                    var6_6 = null;
                    ** GOTO lbl56
                }
                this.out.println("Replication stream: check that vlsns ascend");
                reader /* !! */  = new VerifyReader(envImpl, this.out, this.startLsn, this.endLsn);
            }
            while (reader /* !! */ .readNextEntry()) {
            }
            if (!this.vlsnDump && !this.repGroupDump) {
                ((VerifyReader)reader /* !! */ ).displayLast();
                VLSNIndex.verifyDb(env, this.out, this.verbose);
            }
            System.exit(0);
            ** GOTO lbl63
        }
        catch (Throwable e) {
            e.printStackTrace(this.out);
            System.exit(1);
            var6_8 = null;
            try {
                env.close();
                return;
            }
            catch (Throwable e) {
                e.printStackTrace(this.out);
                System.exit(1);
                return;
            }
        }
        {
            catch (Throwable var5_14) {
                var6_9 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 257->264)] { 
lbl50:
                // 1 sources

                env.close();
                throw var5_14;
lbl52:
                // 1 sources

                catch (Throwable e) {
                    e.printStackTrace(this.out);
                    System.exit(1);
                }
                throw var5_14;
            }
lbl56:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [6 : 257->264)] { 
lbl57:
            // 1 sources

            env.close();
            return;
lbl59:
            // 1 sources

            catch (Throwable e) {
                e.printStackTrace(this.out);
                System.exit(1);
            }
            return;
lbl63:
            // 1 sources

            var6_7 = null;
            try {}
            catch (Throwable e) {}
            e.printStackTrace(this.out);
            System.exit(1);
            return;
            env.close();
            return;
        }
    }

    private class RepGroupReader
    extends DecoderReader {
        RepGroupReader(Environment env, PrintStream out, long startLsn, long endLsn) {
            super(env, out, startLsn, endLsn, DbType.REP_GROUP.getInternalName());
        }

        protected void display() {
            DbStreamVerify.this.out.print(" VLSN=" + this.currentEntryHeader.getVLSN());
            DatabaseEntry key = new DatabaseEntry(this.targetEntry.getKey());
            LN ln = this.targetEntry.getLN();
            if (ln.isDeleted()) {
                this.outStream.print("<deleted>");
            } else {
                DatabaseEntry data = new DatabaseEntry(ln.getData());
                String keyVal = StringBinding.entryToString(key);
                TupleBinding binding = null;
                if (keyVal.equals("$$GROUP_KEY$$")) {
                    this.outStream.print(" GroupInfo: ");
                    binding = new RepGroupDB.GroupBinding();
                } else {
                    this.outStream.print(" NodeInfo: " + keyVal);
                    binding = new RepGroupDB.NodeBinding();
                }
                this.outStream.print(binding.entryToObject(data));
            }
        }
    }

    private class VLSNIndexReader
    extends DecoderReader {
        VLSNIndexReader(Environment env, PrintStream out, long startLsn, long endLsn) {
            super(env, out, startLsn, endLsn, DbType.VLSN_MAP.getInternalName());
        }

        protected void display() {
            DatabaseEntry key = new DatabaseEntry(this.targetEntry.getKey());
            long keyVal = LongBinding.entryToLong(key);
            LN ln = this.targetEntry.getLN();
            if (ln.isDeleted()) {
                this.outStream.println("key=" + keyVal + " <deleted>");
            } else {
                DatabaseEntry data = new DatabaseEntry(ln.getData());
                if (keyVal == -1L) {
                    this.outStream.print(" range: ");
                    VLSNRange range = VLSNRange.readFromDatabase(data);
                    this.outStream.println(range);
                } else {
                    this.outStream.print(" key=" + keyVal);
                    VLSNBucket bucket = VLSNBucket.readFromDatabase(data);
                    this.outStream.println(" " + bucket);
                    if (DbStreamVerify.this.verbose) {
                        this.outStream.println("-------------------------------");
                        bucket.dump(this.outStream);
                        this.outStream.println("-------------------------------\n");
                    }
                }
            }
        }
    }

    private abstract class DecoderReader
    extends FileReader {
        protected final PrintStream outStream;
        private final Map<Byte, LNLogEntry> targetMap;
        protected LNLogEntry targetEntry;
        private final DatabaseId targetDbId;

        DecoderReader(Environment env, PrintStream out, long startLsn, long endLsn, String dbName) {
            super(DbInternal.getEnvironmentImpl(env), 10000, true, startLsn, null, -1L, endLsn);
            this.outStream = out;
            this.targetMap = new HashMap<Byte, LNLogEntry>();
            for (LogEntryType entryType : LogEntryType.getAllTypes()) {
                if (!entryType.isUserLNType()) continue;
                this.targetMap.put(entryType.getTypeNum(), (LNLogEntry)entryType.getNewLogEntry());
            }
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(true);
            DbInternal.setUseExistingConfig(dbConfig, true);
            Database db = env.openDatabase(null, dbName, dbConfig);
            this.targetDbId = DbInternal.getDatabaseImpl(db).getId();
            db.close();
        }

        protected boolean isTargetEntry() {
            this.targetEntry = this.targetMap.get(this.currentEntryHeader.getType());
            return this.targetEntry != null;
        }

        protected boolean processEntry(ByteBuffer entryBuffer) {
            this.targetEntry.readEntry(this.envImpl, this.currentEntryHeader, entryBuffer);
            this.targetEntry.postFetchInit(false);
            if (!this.targetEntry.getDbId().equals(this.targetDbId)) {
                return false;
            }
            this.outStream.print("LSN=" + DbLsn.getNoFormatString(this.getLastLsn()));
            this.display();
            return true;
        }

        protected abstract void display();
    }

    private class VerifyReader
    extends FileReader {
        private VLSN lastVLSN;
        private long lastLSN;
        private final PrintStream out1;

        VerifyReader(EnvironmentImpl envImpl, PrintStream out, long startLsn, long endLsn) {
            super(envImpl, 10000, true, startLsn, null, -1L, endLsn);
            this.lastVLSN = VLSN.NULL_VLSN;
            this.lastLSN = -1L;
            this.out1 = out;
        }

        protected boolean isTargetEntry() {
            return this.currentEntryHeader.getReplicated();
        }

        protected boolean processEntry(ByteBuffer entryBuffer) {
            VLSN currentVLSN = this.currentEntryHeader.getVLSN();
            long currentLSN = this.getLastLsn();
            if (currentVLSN == null) {
                throw new RuntimeException(DbLsn.getNoFormatString(currentLSN) + "Should be a replicated entry");
            }
            if (currentVLSN != null && currentVLSN.isNull()) {
                this.out1.println("unexpected LSN " + DbLsn.getNoFormatString(this.getLastLsn()) + " has vlsn " + currentVLSN);
            }
            if (this.lastVLSN != null && this.lastVLSN.isNull()) {
                this.out1.println("first VLSN = " + currentVLSN + " at lsn " + DbLsn.getNoFormatString(this.getLastLsn()));
            } else if (!this.currentEntryHeader.isInvisible() && !currentVLSN.follows(this.lastVLSN)) {
                this.out1.println("gap of " + (currentVLSN.getSequence() - this.lastVLSN.getSequence()) + " Last=" + this.lastVLSN + " at lsn " + DbLsn.getNoFormatString(this.lastLSN) + " next=" + currentVLSN + " at lsn " + DbLsn.getNoFormatString(currentLSN));
            }
            if (DbStreamVerify.this.showInvisible && this.currentEntryHeader.isInvisible()) {
                this.out1.println("VLSN " + currentVLSN + " at lsn " + DbLsn.getNoFormatString(currentLSN) + " is invisible.");
            }
            if (!this.currentEntryHeader.isInvisible()) {
                this.lastVLSN = currentVLSN;
                this.lastLSN = currentLSN;
            }
            entryBuffer.position(entryBuffer.position() + this.currentEntryHeader.getItemSize());
            return true;
        }

        void displayLast() {
            this.out1.println("LastVLSN = " + this.lastVLSN + " at " + DbLsn.getNoFormatString(this.lastLSN));
        }
    }
}

