/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.config;

import java.io.File;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.InitializationPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.archives.identify.CompositeArchiveIdentificationService;
import org.jboss.windup.rules.apps.java.archives.identify.InMemoryArchiveIdentificationService;
import org.jboss.windup.rules.apps.java.archives.identify.LuceneArchiveIdentificationService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.file.FileSuffixPredicate;
import org.jboss.windup.util.file.FileVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ArchiveIdentificationConfigLoadingRuleProvider
extends AbstractRuleProvider {
    private static final Logger log = Logging.get(ArchiveIdentificationConfigLoadingRuleProvider.class);
    @Inject
    private CompositeArchiveIdentificationService identifier;

    public ArchiveIdentificationConfigLoadingRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(ArchiveIdentificationConfigLoadingRuleProvider.class).setPhase(InitializationPhase.class));
    }

    public Configuration getConfiguration(GraphContext grCtx) {
        return ConfigurationBuilder.begin().addRule().perform((Operation)new AddDelimitedFileIndexOperation()).addRule().perform((Operation)new AddLuceneFileIndexOperation());
    }

    private class AddLuceneFileIndexOperation
    extends GraphOperation {
        private AddLuceneFileIndexOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            Visitor<File> visitor = new Visitor<File>(){

                public void visit(File file) {
                    try {
                        log.info("Loading archive identification data from [" + file.getAbsolutePath() + "]");
                        ArchiveIdentificationConfigLoadingRuleProvider.this.identifier.addIdentifier(new LuceneArchiveIdentificationService(file.getParentFile()));
                    }
                    catch (Exception e) {
                        throw new WindupException("Failed to load identification data from file [" + file + "]", (Throwable)e);
                    }
                }
            };
            FileSuffixPredicate predicate = new FileSuffixPredicate("archive-metadata\\.lucene\\.marker");
            FileVisit.visit((File)PathUtil.getUserCacheDir().resolve("nexus-indexer-data").toFile(), (Predicate)predicate, (Visitor)visitor);
            FileVisit.visit((File)PathUtil.getWindupCacheDir().resolve("nexus-indexer-data").toFile(), (Predicate)predicate, (Visitor)visitor);
        }
    }

    private class AddDelimitedFileIndexOperation
    extends GraphOperation {
        private AddDelimitedFileIndexOperation() {
        }

        public void perform(GraphRewrite event, EvaluationContext context) {
            Visitor<File> visitor = new Visitor<File>(){

                public void visit(File file) {
                    try {
                        log.info("Loading archive identification data from [" + file.getAbsolutePath() + "]");
                        ArchiveIdentificationConfigLoadingRuleProvider.this.identifier.addIdentifier(new InMemoryArchiveIdentificationService().addMappingsFrom(file));
                    }
                    catch (Exception e) {
                        throw new WindupException("Failed to load identification data from file [" + file + "]", (Throwable)e);
                    }
                }
            };
            FileSuffixPredicate predicate = new FileSuffixPredicate("\\.archive-metadata\\.txt");
            FileVisit.visit((File)PathUtil.getUserCacheDir().resolve("nexus-indexer-data").toFile(), (Predicate)predicate, (Visitor)visitor);
            FileVisit.visit((File)PathUtil.getWindupCacheDir().resolve("nexus-indexer-data").toFile(), (Predicate)predicate, (Visitor)visitor);
        }
    }
}

