/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;

public class CachedServiceRegistry
implements ServiceRegistry {
    private final ServiceRegistry delegate;
    private final Map<String, ExportedInstance<?>> instanceCache = new WeakHashMap();
    private final Map<String, Set<ExportedInstance<?>>> instancesCache = new WeakHashMap();

    public CachedServiceRegistry(ServiceRegistry delegate) {
        Assert.notNull(delegate, "Delegated ServiceRegistry should not be null");
        this.delegate = delegate;
    }

    @Override
    public <T> Set<ExportedInstance<T>> getExportedInstances(Class<T> clazz) {
        Set<ExportedInstance<T>> result = this.instancesCache.get(clazz.getName());
        if (result == null) {
            result = this.delegate.getExportedInstances(clazz);
            this.instancesCache.put(clazz.getName(), result);
        }
        return result;
    }

    @Override
    public <T> Set<ExportedInstance<T>> getExportedInstances(String clazz) {
        Set<ExportedInstance<T>> result = this.instancesCache.get(clazz);
        if (result == null) {
            result = this.delegate.getExportedInstances(clazz);
            this.instancesCache.put(clazz, result);
        }
        return result;
    }

    @Override
    public <T> ExportedInstance<T> getExportedInstance(Class<T> type) {
        ExportedInstance<Object> exportedInstance = this.instanceCache.get(type.getName());
        if (exportedInstance == null) {
            exportedInstance = this.delegate.getExportedInstance(type);
            this.instanceCache.put(type.getName(), exportedInstance);
        }
        return exportedInstance;
    }

    @Override
    public <T> ExportedInstance<T> getExportedInstance(String type) {
        ExportedInstance<Object> exportedInstance = this.instanceCache.get(type);
        if (exportedInstance == null) {
            exportedInstance = this.delegate.getExportedInstance(type);
            this.instanceCache.put(type, exportedInstance);
        }
        return exportedInstance;
    }

    @Override
    public Set<Class<?>> getExportedTypes() {
        return this.delegate.getExportedTypes();
    }

    @Override
    public <T> Set<Class<T>> getExportedTypes(Class<T> type) {
        return this.delegate.getExportedTypes(type);
    }

    @Override
    public boolean hasService(Class<?> clazz) {
        return this.delegate.hasService(clazz);
    }

    @Override
    public boolean hasService(String clazz) {
        return this.delegate.hasService(clazz);
    }

    public ServiceRegistry getDelegate() {
        return this.delegate;
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
        this.instanceCache.clear();
        this.instancesCache.clear();
    }
}

