/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.client.query.AbstractHTTPQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sparql.query.QueryStringUtil;

public class SPARQLTupleQuery
extends AbstractHTTPQuery
implements TupleQuery {
    public SPARQLTupleQuery(HTTPClient httpClient, String baseUri, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseUri);
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        HTTPClient client = this.getHttpClient();
        try {
            return client.sendTupleQuery(QueryLanguage.SPARQL, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.maxQueryTime, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        HTTPClient client = this.getHttpClient();
        try {
            client.sendTupleQuery(QueryLanguage.SPARQL, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.maxQueryTime, handler, this.getBindingsArray());
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedQueryException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
        }
    }

    private String getQueryString() {
        return QueryStringUtil.getQueryString(this.queryString, this.getBindings());
    }
}

