/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummaryService;
import org.jboss.windup.reporting.model.Severity;

public class GetProblemSummariesMethod
implements WindupFreeMarkerMethod {
    public static final String NAME = "getProblemSummaries";
    private GraphContext context;

    @Override
    public String getMethodName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Returns a summary of all classification and hints found during analysis in the form of a List<" + ProblemSummary.class.getSimpleName() + ">.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        StringModel projectModelArg;
        ProjectModel projectModel = arguments.size() > 0 ? ((projectModelArg = (StringModel)arguments.get(0)) == null ? null : (ProjectModel)projectModelArg.getWrappedObject()) : null;
        Set<String> includeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)arguments.get(1));
        Set<String> excludeTags = FreeMarkerUtil.simpleSequenceToSet((SimpleSequence)arguments.get(2));
        Map<Severity, List<ProblemSummary>> problemSummaries = ProblemSummaryService.getProblemSummaries(this.context, projectModel, includeTags, excludeTags);
        HashMap<String, List<ProblemSummary>> primarySummariesByString = new HashMap<String, List<ProblemSummary>>(problemSummaries.size());
        for (Map.Entry<Severity, List<ProblemSummary>> entry : problemSummaries.entrySet()) {
            String severityString = entry.getKey() == null ? null : entry.getKey().toString();
            primarySummariesByString.put(severityString, entry.getValue());
        }
        return primarySummariesByString;
    }

    @Override
    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }
}

