/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.freemarker.problemsummary.RuleSummaryKey;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.model.Severity;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;

public class ProblemSummaryService {
    public static Map<Severity, List<ProblemSummary>> getProblemSummaries(GraphContext context, ProjectModel projectModel, Set<String> includeTags, Set<String> excludeTags) {
        TreeMap<Severity, List<ProblemSummary>> results = new TreeMap<Severity, List<ProblemSummary>>(new Comparator<Severity>(){

            @Override
            public int compare(Severity severity1, Severity severity2) {
                return severity1.ordinal() - severity2.ordinal();
            }
        });
        HashMap<RuleSummaryKey, ProblemSummary> ruleToSummary = new HashMap<RuleSummaryKey, ProblemSummary>();
        InlineHintService hintService = new InlineHintService(context);
        Iterable<InlineHintModel> hints = projectModel == null ? hintService.findAll() : hintService.getHintsForProject(projectModel, true);
        for (InlineHintModel hint : hints) {
            Set tags = hint.getTags();
            if (!TagUtil.checkMatchingTags(tags, includeTags, excludeTags, false)) continue;
            RuleSummaryKey key = new RuleSummaryKey(hint.getRuleID(), hint.getTitle());
            ProblemSummary summary = (ProblemSummary)ruleToSummary.get(key);
            if (summary == null) {
                summary = new ProblemSummary(hint.getSeverity(), hint.getRuleID(), hint.getTitle(), 1, hint.getEffort());
                ruleToSummary.put(key, summary);
                ProblemSummaryService.addToResults(results, summary);
            } else {
                summary.setNumberFound(summary.getNumberFound() + 1);
            }
            summary.addFile(hint.getHint(), hint.getFile());
        }
        ClassificationService classificationService = new ClassificationService(context);
        for (ClassificationModel classification : classificationService.findAll()) {
            Set tags = classification.getTags();
            if (!TagUtil.checkMatchingTags(tags, includeTags, excludeTags, false)) continue;
            ArrayList<FileModel> newFileModels = new ArrayList<FileModel>();
            for (FileModel file : classification.getFileModels()) {
                if (projectModel != null) {
                    boolean projectMatches = false;
                    for (ProjectModel fileProject = file.getProjectModel(); fileProject != null; fileProject = fileProject.getParentProject()) {
                        if (!fileProject.equals(projectModel)) continue;
                        projectMatches = true;
                        break;
                    }
                    if (!projectMatches) continue;
                }
                newFileModels.add(file);
            }
            if (newFileModels.isEmpty()) continue;
            RuleSummaryKey key = new RuleSummaryKey(classification.getRuleID(), classification.getClassification());
            ProblemSummary summary = (ProblemSummary)ruleToSummary.get(key);
            if (summary == null) {
                summary = new ProblemSummary(classification.getSeverity(), classification.getRuleID(), classification.getClassification(), 0, classification.getEffort());
                ruleToSummary.put(key, summary);
                ProblemSummaryService.addToResults(results, summary);
            }
            for (FileModel file : newFileModels) {
                summary.addFile(classification.getDescription(), file);
            }
            summary.setNumberFound(summary.getNumberFound() + newFileModels.size());
        }
        return results;
    }

    private static void addToResults(Map<Severity, List<ProblemSummary>> results, ProblemSummary summary) {
        List<ProblemSummary> list = results.get((Object)summary.getSeverity());
        if (list == null) {
            list = new ArrayList<ProblemSummary>();
            results.put(summary.getSeverity(), list);
        }
        list.add(summary);
    }
}

