/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.rules;

import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.PostReportGenerationPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFind;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.reporting.model.ApplicationReportIndexModel;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.service.ApplicationReportIndexService;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AttachApplicationReportsToIndexRuleProvider
extends AbstractRuleProvider {
    public AttachApplicationReportsToIndexRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(AttachApplicationReportsToIndexRuleProvider.class).setPhase(PostReportGenerationPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        QueryBuilderFind applicationReportFound = Query.fromType(ApplicationReportModel.class);
        AddToApplicationIndex addToApplicationIndex = new AddToApplicationIndex();
        return ConfigurationBuilder.begin().addRule().when((Condition)applicationReportFound).perform((Operation)addToApplicationIndex);
    }

    private class AddToApplicationIndex
    extends AbstractIterationOperation<ApplicationReportModel> {
        private AddToApplicationIndex() {
        }

        public void perform(GraphRewrite event, EvaluationContext context, ApplicationReportModel payload) {
            ApplicationReportIndexModel index;
            ApplicationReportIndexService applicationReportIndexService = new ApplicationReportIndexService(event.getGraphContext());
            ProjectModel projectModel = payload.getProjectModel();
            if (projectModel == null || Boolean.TRUE == payload.getDisplayInGlobalApplicationIndex()) {
                index = applicationReportIndexService.getOrCreateGlobalApplicationIndex();
                index.addApplicationReportModel(payload);
            }
            if (projectModel != null) {
                index = applicationReportIndexService.getApplicationReportIndexForProjectModel(payload.getProjectModel());
                index.addApplicationReportModel(payload);
            }
        }

        public String toString() {
            return "AddToApplicationIndex";
        }
    }
}

