/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.TagUtil;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.rules.files.model.FileReferenceModel;

public class InlineHintService
extends GraphService<InlineHintModel> {
    public InlineHintService(GraphContext context) {
        super(context, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFileReference(FileReferenceModel reference) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)reference.asVertex());
        inlineHintPipeline.in(new String[]{"Hint:fileLocationReference"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFile(FileModel file) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)file.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline, InlineHintModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)fileModel.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("EffortReportModelEffort", (Predicate)Compare.GREATER_THAN, (Object)0);
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline) {
            hintEffort += ((Integer)v.getProperty("EffortReportModelEffort")).intValue();
        }
        return hintEffort;
    }

    private Collection<Vertex> getProjectAndChildren(ProjectModel projectModel) {
        ArrayList<Vertex> result = new ArrayList<Vertex>();
        result.add(projectModel.asVertex());
        for (ProjectModel child : projectModel.getChildProjects()) {
            result.addAll(this.getProjectAndChildren(child));
        }
        return result;
    }

    public Iterable<InlineHintModel> getHintsForProject(ProjectModel projectModel, boolean recursive) {
        Collection<Vertex> initialVertices = recursive ? this.getProjectAndChildren(projectModel) : Collections.singletonList(projectModel.asVertex());
        GremlinPipeline inlineHintPipeline = new GremlinPipeline(initialVertices);
        inlineHintPipeline.out(new String[]{"projectModelToFile"});
        inlineHintPipeline.in(new String[]{"file"}).has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        ArrayList<InlineHintModel> results = new ArrayList<InlineHintModel>();
        for (Vertex v : inlineHintPipeline) {
            results.add((InlineHintModel)this.frame(v));
        }
        return results;
    }

    public int getMigrationEffortPoints(ProjectModel initialProject, Set<String> includeTags, Set<String> excludeTags, boolean recursive) {
        final HashSet<Vertex> initialVertices = new HashSet<Vertex>();
        if (recursive) {
            for (ProjectModel projectModel1 : initialProject.getAllProjectModels()) {
                initialVertices.add(projectModel1.asVertex());
            }
        } else {
            initialVertices.add(initialProject.asVertex());
        }
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)this.getGraphContext().getGraph());
        inlineHintPipeline.V();
        inlineHintPipeline.has("EffortReportModelEffort", (Predicate)Compare.GREATER_THAN, (Object)0);
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Hint");
        inlineHintPipeline.as("hint");
        inlineHintPipeline.out(new String[]{"file"});
        inlineHintPipeline.out(new String[]{"fileToProjectModel"});
        inlineHintPipeline.filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

            public Boolean compute(Vertex argument) {
                return initialVertices.contains(argument);
            }
        });
        inlineHintPipeline.back("hint");
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline) {
            InlineHintModel hintModel;
            if ((!includeTags.isEmpty() || !excludeTags.isEmpty()) && !TagUtil.checkMatchingTags((hintModel = (InlineHintModel)this.frame(v)).getTags(), includeTags, excludeTags)) continue;
            hintEffort += ((Integer)v.getProperty("EffortReportModelEffort")).intValue();
        }
        return hintEffort;
    }
}

