/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.forge.addon.resource.DefaultFileOperations;
import org.jboss.forge.addon.resource.FileOperations;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.ResourceGenerator;
import org.jboss.forge.addon.resource.monitor.FileMonitor;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.addon.resource.transaction.ResourceTransactionListener;
import org.jboss.forge.addon.resource.transaction.file.FileResourceTransactionImpl;
import org.jboss.forge.addon.resource.transaction.file.FileResourceTransactionManager;
import org.jboss.forge.addon.resource.util.RelatedClassComparator;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.spi.ListenerRegistration;
import org.jboss.forge.furnace.util.Assert;

public class ResourceFactoryImpl
implements ResourceFactory {
    private final Set<ResourceGenerator> generators = new HashSet<ResourceGenerator>();
    private volatile long version = -1L;

    public <E, T extends Resource<E>> T create(Class<T> type, E underlyingResource) {
        Resource result = null;
        TreeMap<Class, ResourceGenerator> generated = new TreeMap<Class, ResourceGenerator>((Comparator<Class>)new RelatedClassComparator());
        for (ResourceGenerator generator : this.getGenerators()) {
            Class resourceType;
            if (generator.handles(type, underlyingResource) && type.isAssignableFrom(resourceType = generator.getResourceType((ResourceFactory)this, type, underlyingResource))) {
                generated.put(resourceType, generator);
            }
            if (generated.size() <= 0) continue;
            result = ((ResourceGenerator)generated.lastEntry().getValue()).getResource((ResourceFactory)this, type, underlyingResource);
        }
        return (T)result;
    }

    private Iterable<ResourceGenerator> getGenerators() {
        if (this.getAddonRegistry().getVersion() != this.version) {
            this.version = this.getAddonRegistry().getVersion();
            this.generators.clear();
            for (ResourceGenerator generator : this.getAddonRegistry().getServices(ResourceGenerator.class)) {
                this.generators.add(generator);
            }
        }
        return this.generators;
    }

    public <E> Resource<E> create(E underlyingResource) {
        return this.create(Resource.class, underlyingResource);
    }

    public ResourceMonitor monitor(Resource<?> resource) {
        return this.monitor(resource, null);
    }

    public ResourceMonitor monitor(Resource<?> resource, ResourceFilter resourceFilter) {
        Assert.notNull(resource, (String)"Resource cannot be null");
        Assert.isTrue((boolean)(resource instanceof FileResource), (String)("Resource must be a FileResource, was " + resource.getClass().getName()));
        if (!resource.exists()) {
            throw new IllegalStateException("Resource must exist to be monitored");
        }
        FileResource fileResource = (FileResource)resource;
        return this.getFileMonitor().registerMonitor(this, fileResource, resourceFilter);
    }

    public FileResourceTransactionImpl getTransaction() {
        return this.getTransactionManager().getCurrentTransaction(this);
    }

    public FileOperations getFileOperations() {
        FileResourceTransactionImpl transaction = this.getTransaction();
        if (transaction.isStarted()) {
            return transaction;
        }
        return DefaultFileOperations.INSTANCE;
    }

    public ListenerRegistration<ResourceTransactionListener> addTransactionListener(ResourceTransactionListener listener) {
        return this.getTransactionManager().addTransactionListener(listener);
    }

    private AddonRegistry getAddonRegistry() {
        return SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
    }

    private FileMonitor getFileMonitor() {
        return (FileMonitor)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), FileMonitor.class).get();
    }

    private FileResourceTransactionManager getTransactionManager() {
        return (FileResourceTransactionManager)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), FileResourceTransactionManager.class).get();
    }
}

