/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.util.ResourcePathResolver;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.progress.UIProgressMonitor;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.exec.configuration.options.InputPathOption;
import org.jboss.windup.exec.configuration.options.OutputPathOption;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.ui.DefaultValueAdapter;
import org.jboss.windup.ui.WindupProgressMonitorAdapter;

public class WindupCommand
implements UICommand {
    private Map<ConfigurationOption, InputComponent<?, ?>> inputOptions = new LinkedHashMap();
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private GraphContextFactory graphContextFactory;
    @Inject
    private WindupProcessor processor;
    @Inject
    private ResourceFactory resourceFactory;
    private Set<ValidationResult> promptMessages = new HashSet<ValidationResult>();

    public UICommandMetadata getMetadata(UIContext ctx) {
        return Metadata.forCommand(this.getClass()).name("Windup Migrate App").description("Run Windup Migration Analyzer").category(Categories.create((String[])new String[]{"Platform", "Migration"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.initializeConfigurationOptionComponents(builder);
        final UIInputMany inputPaths = (UIInputMany)this.getInputForOption(InputPathOption.class);
        final UIInput outputPath = (UIInput)this.getInputForOption(OutputPathOption.class);
        outputPath.setDefaultValue((Callable)new Callable<DirectoryResource>(){

            @Override
            public DirectoryResource call() throws Exception {
                Iterable inputPathsIterable = inputPaths.getValue();
                if (inputPathsIterable.iterator().hasNext()) {
                    File value = (File)inputPathsIterable.iterator().next();
                    File childDirectory = new File(value.getCanonicalFile().getParentFile(), value.getName() + ".report");
                    return (DirectoryResource)WindupCommand.this.resourceFactory.create(DirectoryResource.class, (Object)childDirectory);
                }
                return null;
            }
        });
        outputPath.addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                File outputFile = (File)WindupCommand.this.getValueForInput(WindupCommand.this.getOption("output"), (InputComponent)outputPath);
                UIInputMany inputPathsUI = (UIInputMany)WindupCommand.this.getInputForOption(InputPathOption.class);
                Iterable inputPathsIterable = inputPathsUI.getValue();
                for (File inputFile : inputPathsIterable) {
                    if (inputFile.equals(outputFile)) {
                        context.addValidationError((InputComponent)outputPath, "Output file cannot be the same as the input file.");
                    }
                    for (File inputParent = inputFile.getParentFile(); inputParent != null; inputParent = inputParent.getParentFile()) {
                        if (!inputParent.equals(outputFile)) continue;
                        context.addValidationError((InputComponent)outputPath, "Output path must not be a parent of input path.");
                    }
                    for (File outputParent = outputFile.getParentFile(); outputParent != null; outputParent = outputParent.getParentFile()) {
                        if (!outputParent.equals(inputFile)) continue;
                        context.addValidationError((InputComponent)inputPathsUI, "Input path must not be a parent of output path.");
                    }
                }
            }
        });
    }

    public void validate(UIValidationContext context) {
        for (Map.Entry<ConfigurationOption, InputComponent<?, ?>> entry : this.inputOptions.entrySet()) {
            Object inputValue;
            InputComponent<?, ?> inputComponent = entry.getValue();
            ConfigurationOption option = entry.getKey();
            ValidationResult result = option.validate(inputValue = this.getValueForInput(option, inputComponent));
            if (result.getLevel().equals((Object)ValidationResult.Level.ERROR)) {
                context.addValidationError(inputComponent, result.getMessage());
            }
            if (result.getLevel().equals((Object)ValidationResult.Level.PROMPT_TO_CONTINUE)) {
                this.promptMessages.add(result);
            }
            if (!result.getLevel().equals((Object)ValidationResult.Level.WARNING)) continue;
            context.addValidationWarning(inputComponent, result.getMessage());
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        if (!this.promptMessages.isEmpty()) {
            for (ValidationResult message : this.promptMessages) {
                UIOutput output = context.getUIContext().getProvider().getOutput();
                output.warn(output.out(), message.getMessage());
            }
            if (!context.getPrompt().promptBoolean("Would you like to continue?", true)) {
                return Results.fail((String)"Aborted by the user.");
            }
        }
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        for (Map.Entry<ConfigurationOption, InputComponent<?, ?>> entry : this.inputOptions.entrySet()) {
            ConfigurationOption option = entry.getKey();
            String name = option.getName();
            Object value = this.getValueForInput(option, entry.getValue());
            windupConfiguration.setOptionValue(name, value);
        }
        windupConfiguration.useDefaultDirectories();
        Boolean overwrite = (Boolean)windupConfiguration.getOptionMap().get("overwrite");
        if (overwrite == null) {
            overwrite = false;
        }
        if (!overwrite.booleanValue() && this.pathNotEmpty(windupConfiguration.getOutputDirectory().toFile())) {
            String promptMsg = "Overwrite all contents of \"" + windupConfiguration.getOutputDirectory().toString() + "\" (anything already in the directory will be deleted)?";
            if (!context.getPrompt().promptBoolean(promptMsg, false)) {
                String outputPath = windupConfiguration.getOutputDirectory().toString();
                return Results.fail((String)("Files exist in " + outputPath + ", but --overwrite not specified. Aborting!"));
            }
        }
        context.getUIContext().getAttributeMap().put(WindupConfiguration.class, windupConfiguration);
        FileUtils.deleteQuietly((File)windupConfiguration.getOutputDirectory().toFile());
        Path graphPath = windupConfiguration.getOutputDirectory().resolve("graph");
        try (GraphContext graphContext = this.graphContextFactory.create(graphPath);){
            context.getUIContext().getAttributeMap().put(GraphContext.class, graphContext);
            UIProgressMonitor uiProgressMonitor = context.getProgressMonitor();
            WindupProgressMonitorAdapter progressMonitor = new WindupProgressMonitorAdapter(uiProgressMonitor);
            windupConfiguration.setProgressMonitor((WindupProgressMonitor)progressMonitor).setGraphContext(graphContext);
            this.processor.execute(windupConfiguration);
            uiProgressMonitor.done();
            Path indexHtmlPath = windupConfiguration.getOutputDirectory().resolve("index.html").normalize().toAbsolutePath();
            Result result = Results.success((String)("Windup report created: " + indexHtmlPath + System.getProperty("line.separator") + "              Access it at this URL: " + indexHtmlPath.toUri()));
            return result;
        }
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    private void initializeConfigurationOptionComponents(UIBuilder builder) {
        for (ConfigurationOption option : WindupConfiguration.getWindupConfigurationOptions()) {
            UIInput inputComponent = null;
            switch (option.getUIType()) {
                case SINGLE: {
                    UIInput inputSingle = this.componentFactory.createInput(option.getName(), option.getType());
                    inputSingle.setDefaultValue(new DefaultValueAdapter(option));
                    inputComponent = inputSingle;
                    break;
                }
                case MANY: {
                    Class optionType = option.getType() == Path.class ? File.class : option.getType();
                    UIInputMany inputMany = this.componentFactory.createInputMany(option.getName(), optionType);
                    inputMany.setDefaultValue(new DefaultValueAdapter<Iterable>(option, Iterable.class));
                    inputComponent = inputMany;
                    break;
                }
                case SELECT_MANY: {
                    UISelectMany selectMany = this.componentFactory.createSelectMany(option.getName(), option.getType());
                    selectMany.setValueChoices((Iterable)option.getAvailableValues());
                    selectMany.setDefaultValue(new DefaultValueAdapter<Iterable>(option, Iterable.class));
                    inputComponent = selectMany;
                    break;
                }
                case SELECT_ONE: {
                    UISelectOne selectOne = this.componentFactory.createSelectOne(option.getName(), option.getType());
                    selectOne.setValueChoices((Iterable)option.getAvailableValues());
                    selectOne.setDefaultValue(new DefaultValueAdapter(option));
                    inputComponent = selectOne;
                    break;
                }
                case DIRECTORY: {
                    UIInput directoryInput = this.componentFactory.createInput(option.getName(), DirectoryResource.class);
                    directoryInput.setDefaultValue(new DefaultValueAdapter<DirectoryResource>(option, DirectoryResource.class));
                    inputComponent = directoryInput;
                    break;
                }
                case FILE: {
                    UIInput fileInput = this.componentFactory.createInput(option.getName(), FileResource.class);
                    fileInput.setDefaultValue(new DefaultValueAdapter<FileResource>(option, FileResource.class));
                    inputComponent = fileInput;
                    break;
                }
                case FILE_OR_DIRECTORY: {
                    UIInput fileOrDirInput = this.componentFactory.createInput(option.getName(), FileResource.class);
                    fileOrDirInput.setDefaultValue(new DefaultValueAdapter<FileResource>(option, FileResource.class));
                    inputComponent = fileOrDirInput;
                    break;
                }
            }
            if (inputComponent == null) {
                throw new IllegalArgumentException("Could not build input component for: " + option);
            }
            inputComponent.setLabel(option.getLabel());
            inputComponent.setRequired(option.isRequired());
            inputComponent.setDescription(option.getDescription());
            builder.add((InputComponent)inputComponent);
            this.inputOptions.put(option, (InputComponent<?, ?>)inputComponent);
        }
    }

    private ConfigurationOption getOption(String name) {
        for (Map.Entry<ConfigurationOption, InputComponent<?, ?>> entry : this.inputOptions.entrySet()) {
            if (!StringUtils.equals((String)name, (String)entry.getKey().getName())) continue;
            return entry.getKey();
        }
        return null;
    }

    private InputComponent<?, ?> getInputForOption(Class<? extends ConfigurationOption> option) {
        for (Map.Entry<ConfigurationOption, InputComponent<?, ?>> entry : this.inputOptions.entrySet()) {
            if (!option.isAssignableFrom(entry.getKey().getClass())) continue;
            return entry.getValue();
        }
        return null;
    }

    private Object getValueForInput(ConfigurationOption option, InputComponent<?, ?> input) {
        LinkedHashSet<Path> value = input.getValue();
        if (value == null) {
            return value;
        }
        if (value instanceof Resource) {
            Resource<?> resourceResolved = this.getResourceResolved((Resource)value);
            return resourceResolved.getUnderlyingResourceObject();
        }
        if (option.getType() == Path.class) {
            LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
            if (value instanceof List) {
                for (Object path : (List)((Object)value)) {
                    if (path instanceof File) {
                        path = ((File)path).toPath();
                    }
                    paths.add((Path)path);
                }
            }
            value = paths;
        }
        return value;
    }

    private Resource<?> getResourceResolved(Resource<?> value) {
        Resource<?> resource = value;
        File file = (File)resource.getUnderlyingResourceObject();
        return (Resource)new ResourcePathResolver(this.resourceFactory, resource, file.getPath()).resolve().get(0);
    }

    private boolean pathNotEmpty(File f) {
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return f.isDirectory() && f.listFiles() != null && f.listFiles().length > 0;
    }
}

