/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.facet;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.InitCommand;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;

public class GitFacetImpl
extends AbstractFacet<Project>
implements GitFacet {
    static final Logger logger = Logger.getLogger(GitFacetImpl.class.getName());

    public boolean install() {
        Project project = (Project)this.getFaceted();
        DirectoryResource rootDirectory = (DirectoryResource)project.getRoot().reify(DirectoryResource.class);
        FileResource gitDir = (FileResource)rootDirectory.getChild(".git").reify(FileResource.class);
        if (!gitDir.exists()) {
            InitCommand init = Git.init();
            init.setDirectory((File)rootDirectory.getUnderlyingResourceObject());
            try {
                init.call().close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while initializing directory", e);
            }
        }
        return true;
    }

    public boolean isInstalled() {
        DirectoryResource root = (DirectoryResource)((Project)this.getFaceted()).getRoot().reify(DirectoryResource.class);
        return root != null && root.getChildDirectory(".git").exists();
    }
}

