/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import java.util.LinkedList;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.facet.GitIgnoreFacet;
import org.jboss.forge.addon.git.gitignore.GitIgnoreTemplateGroup;
import org.jboss.forge.addon.git.gitignore.resources.GitIgnoreResource;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitIgnoreCreateCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;

@FacetConstraint(value={GitFacet.class, GitIgnoreFacet.class})
public class GitIgnoreCreateCommandImpl
extends AbstractGitCommand
implements GitIgnoreCreateCommand {
    private UIInput<String> templates;

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.templates = (UIInput)((UIInput)this.getInputComponentFactory().createInput("templates", String.class).setLabel("From templates")).setRequired(true);
        this.templates.setCompleter((UICompleter)new GitIgnoreTemplateCompleter(this.getSelectedProject(builder.getUIContext())));
        builder.add(this.templates);
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GITIGNORE: Create").description("Create .gitignore from templates");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        GitIgnoreFacet facet = (GitIgnoreFacet)this.getSelectedProject((UIContextProvider)context).getFacet(GitIgnoreFacet.class);
        GitIgnoreResource resource = this.gitIgnoreResource(context.getUIContext());
        StringBuffer buffer = new StringBuffer();
        for (String template : ((String)this.templates.getValue()).split(" ")) {
            String content = facet.contentOf(template);
            buffer.append(content).append("\n");
        }
        String content = buffer.toString();
        resource.setContents(content);
        StringBuilder resultString = new StringBuilder();
        resultString.append("Wrote to .gitignore. Content:").append("\n");
        resultString.append(content).append("\n");
        context.getUIContext().setSelection((Object)resource);
        return Results.success((String)resultString.toString());
    }

    private static class GitIgnoreTemplateCompleter
    implements UICompleter<String> {
        private final Project currentProject;

        private GitIgnoreTemplateCompleter(Project currentProject) {
            this.currentProject = currentProject;
        }

        public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
            LinkedList<String> result = new LinkedList<String>();
            String[] values = value.split(" ");
            for (GitIgnoreTemplateGroup group : ((GitIgnoreFacet)this.currentProject.getFacet(GitIgnoreFacet.class)).list()) {
                for (String template : group.getTemplates()) {
                    if (!Strings.isNullOrEmpty((String)values[values.length - 1]) && !template.startsWith(values[values.length - 1])) continue;
                    result.add(template);
                }
            }
            return result;
        }
    }
}

