/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.git.ui;

import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.git.facet.GitFacet;
import org.jboss.forge.addon.git.facet.GitIgnoreFacet;
import org.jboss.forge.addon.git.gitignore.GitIgnoreTemplateGroup;
import org.jboss.forge.addon.git.ui.AbstractGitCommand;
import org.jboss.forge.addon.git.ui.GitIgnoreListTemplatesCommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={GitFacet.class, GitIgnoreFacet.class})
public class GitIgnoreListTemplatesCommandImpl
extends AbstractGitCommand
implements GitIgnoreListTemplatesCommand {
    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("GITIGNORE: List templates").description("List all available .gitignore templates");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Installed .gitignore templates:").append("\n");
        for (GitIgnoreTemplateGroup group : ((GitIgnoreFacet)this.getSelectedProject((UIContextProvider)context).getFacet(GitIgnoreFacet.class)).list()) {
            sb.append("============= " + group.getName() + " =============").append("\n");
            for (String template : group.getTemplates()) {
                sb.append(template).append("\n");
            }
        }
        return Results.success((String)sb.toString());
    }
}

