/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap.commands.addons;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.maven.addon.MavenAddonDependencyResolver;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.windup.bootstrap.Bootstrap;
import org.jboss.windup.bootstrap.commands.Command;
import org.jboss.windup.bootstrap.commands.CommandPhase;
import org.jboss.windup.bootstrap.commands.CommandResult;
import org.jboss.windup.bootstrap.commands.FurnaceDependent;
import org.jboss.windup.bootstrap.commands.addons.AbstractAddonCommand;

public class RemoveAddonCommand
extends AbstractAddonCommand
implements Command,
FurnaceDependent {
    private Furnace furnace;
    private final String addonId;
    private final AtomicBoolean batchMode;

    public RemoveAddonCommand(String addonId, AtomicBoolean batchMode) {
        this.addonId = addonId;
        this.batchMode = batchMode;
    }

    @Override
    public void setFurnace(Furnace furnace) {
        this.furnace = furnace;
    }

    @Override
    public CommandResult execute() {
        this.remove(this.addonId, this.batchMode.get());
        return CommandResult.CONTINUE;
    }

    void remove(String coordinates, boolean batchMode) {
        try {
            MavenAddonDependencyResolver resolver = new MavenAddonDependencyResolver();
            AddonManagerImpl addonManager = new AddonManagerImpl(this.furnace, (AddonDependencyResolver)resolver);
            AddonId addon = null;
            coordinates = RemoveAddonCommand.convertColonVersionToComma(coordinates);
            if (coordinates.matches("(.*?):(.*?),(.*)")) {
                addon = AddonId.fromCoordinates((String)coordinates);
                coordinates = addon.getName();
            }
            block2: for (AddonRepository repository : this.furnace.getRepositories()) {
                for (AddonId id : repository.listEnabled()) {
                    String result;
                    if (!coordinates.equals(id.getName()) || !(repository instanceof MutableAddonRepository)) continue;
                    addon = id;
                    RemoveRequest request = addonManager.remove(id, repository);
                    System.out.println(request);
                    if (!batchMode && "n".equalsIgnoreCase((result = System.console().readLine("Confirm uninstallation [Y/n]? ", new Object[0])).trim())) {
                        System.out.println("Uninstallation aborted.");
                        return;
                    }
                    request.perform();
                    System.out.println("Uninstallation completed successfully.");
                    System.out.println();
                    break block2;
                }
            }
            if (addon == null) {
                throw new IllegalArgumentException("No addon exists with id " + coordinates);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(Bootstrap.getVersionString());
        }
    }

    @Override
    public CommandPhase getPhase() {
        return CommandPhase.POST_CONFIGURATION;
    }
}

