/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Predicate;

public enum Compare implements Predicate
{
    EQUAL,
    NOT_EQUAL,
    GREATER_THAN,
    GREATER_THAN_EQUAL,
    LESS_THAN,
    LESS_THAN_EQUAL;


    @Override
    public boolean evaluate(Object first, Object second) {
        switch (this) {
            case EQUAL: {
                if (null == first) {
                    return second == null;
                }
                return first.equals(second);
            }
            case NOT_EQUAL: {
                if (null == first) {
                    return second != null;
                }
                return !first.equals(second);
            }
            case GREATER_THAN: {
                if (null == first || second == null) {
                    return false;
                }
                return ((Comparable)first).compareTo(second) >= 1;
            }
            case LESS_THAN: {
                if (null == first || second == null) {
                    return false;
                }
                return ((Comparable)first).compareTo(second) <= -1;
            }
            case GREATER_THAN_EQUAL: {
                if (null == first || second == null) {
                    return false;
                }
                return ((Comparable)first).compareTo(second) >= 0;
            }
            case LESS_THAN_EQUAL: {
                if (null == first || second == null) {
                    return false;
                }
                return ((Comparable)first).compareTo(second) <= 0;
            }
        }
        throw new IllegalArgumentException("Invalid state as no valid filter was provided");
    }

    public Compare opposite() {
        if (this.equals(EQUAL)) {
            return NOT_EQUAL;
        }
        if (this.equals(NOT_EQUAL)) {
            return EQUAL;
        }
        if (this.equals(GREATER_THAN)) {
            return LESS_THAN_EQUAL;
        }
        if (this.equals(GREATER_THAN_EQUAL)) {
            return LESS_THAN;
        }
        if (this.equals(LESS_THAN)) {
            return GREATER_THAN_EQUAL;
        }
        if (this.equals(LESS_THAN_EQUAL)) {
            return GREATER_THAN;
        }
        throw new RuntimeException("Comparator does not have an opposite");
    }

    public String asString() {
        if (this.equals(EQUAL)) {
            return "=";
        }
        if (this.equals(GREATER_THAN)) {
            return ">";
        }
        if (this.equals(GREATER_THAN_EQUAL)) {
            return ">=";
        }
        if (this.equals(LESS_THAN_EQUAL)) {
            return "<=";
        }
        if (this.equals(LESS_THAN)) {
            return "<";
        }
        if (this.equals(NOT_EQUAL)) {
            return "<>";
        }
        throw new RuntimeException("Comparator does not have a string representation");
    }

    public static Compare fromString(String c) {
        if (c.equals("=")) {
            return EQUAL;
        }
        if (c.equals("<>")) {
            return NOT_EQUAL;
        }
        if (c.equals(">")) {
            return GREATER_THAN;
        }
        if (c.equals(">=")) {
            return GREATER_THAN_EQUAL;
        }
        if (c.equals("<")) {
            return LESS_THAN;
        }
        if (c.equals("<=")) {
            return LESS_THAN_EQUAL;
        }
        throw new IllegalArgumentException("Argument does not match any comparator");
    }
}

