/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy.javassist;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javassist.util.proxy.MethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeHandler
implements MethodHandler,
Serializable {
    protected static final String OBJECT_CLASS_NAME = Object.class.getName();
    private List<MethodHandler> methodHandlers = new ArrayList<MethodHandler>();
    private static ThreadLocal<Integer> currentHandlerIndex = new ThreadLocal();

    public CompositeHandler(List<MethodHandler> methodHandlers) {
        this.methodHandlers.addAll(methodHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (thisMethod.getDeclaringClass().getName().equals(OBJECT_CLASS_NAME)) {
            return proceed.invoke(self, new Object[0]);
        }
        boolean isOuter = false;
        if (currentHandlerIndex.get() == null) {
            isOuter = true;
            currentHandlerIndex.set(0);
        } else {
            currentHandlerIndex.set(currentHandlerIndex.get() + 1);
        }
        try {
            if (currentHandlerIndex.get() < this.methodHandlers.size()) {
                Object object = this.methodHandlers.get(currentHandlerIndex.get()).invoke(self, thisMethod, proceed, args);
                return object;
            }
            if (proceed != null) {
                Object object = proceed.invoke(self, args);
                return object;
            }
        }
        finally {
            if (isOuter) {
                currentHandlerIndex.set(null);
            }
        }
        return null;
    }
}

