/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.condition;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.condition.EvaluationStrategy;
import org.jboss.windup.config.condition.NoopEvaluationStrategy;
import org.jboss.windup.config.parameters.FrameContext;
import org.jboss.windup.config.parameters.FrameCreationContext;
import org.jboss.windup.config.parameters.ParameterizedGraphCondition;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderFrom;
import org.jboss.windup.config.query.QueryBuilderPiped;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.query.QueryPropertyComparisonType;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilder;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderAt;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderInFile;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderLineMatch;
import org.jboss.windup.rules.apps.java.condition.JavaClassBuilderReferences;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactory;
import org.jboss.windup.rules.files.model.FileReferenceModel;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterStore;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;
import org.ocpsoft.rewrite.util.Maps;

public class JavaClass
extends ParameterizedGraphCondition
implements JavaClassBuilder,
JavaClassBuilderAt,
JavaClassBuilderInFile,
JavaClassBuilderLineMatch {
    private static final AtomicInteger numberCreated = new AtomicInteger(0);
    private final String uniqueID;
    private List<TypeReferenceLocation> locations = Collections.emptyList();
    private final RegexParameterizedPatternParser referencePattern;
    private RegexParameterizedPatternParser lineMatchPattern;
    private RegexParameterizedPatternParser typeFilterPattern;

    private JavaClass(String referencePattern) {
        this.referencePattern = new RegexParameterizedPatternParser(referencePattern);
        this.uniqueID = numberCreated.incrementAndGet() + "_JavaClass";
    }

    public static JavaClassBuilder references(String regex) {
        return new JavaClass(regex);
    }

    public static JavaClassBuilderReferences from(String inputVarName) {
        return new JavaClassBuilderReferences(inputVarName);
    }

    @Override
    public JavaClassBuilderInFile inType(String typeFilterPattern) {
        this.typeFilterPattern = new RegexParameterizedPatternParser(typeFilterPattern);
        return this;
    }

    @Override
    public JavaClassBuilderLineMatch matchesSource(String lineMatchRegex) {
        this.lineMatchPattern = new RegexParameterizedPatternParser(lineMatchRegex);
        return this;
    }

    @Override
    public JavaClassBuilderAt at(TypeReferenceLocation ... locations) {
        if (locations != null) {
            this.locations = Arrays.asList(locations);
        }
        return this;
    }

    @Override
    public ConditionBuilder as(String variable) {
        Assert.notNull((Object)variable, (String)"Variable name must not be null.");
        this.setOutputVariablesName(variable);
        return this;
    }

    protected boolean evaluateAndPopulateValueStores(GraphRewrite event, EvaluationContext context, final FrameCreationContext frameCreationContext) {
        return this.evaluate(event, context, new EvaluationStrategy(){
            private LinkedHashMap<String, List<WindupVertexFrame>> variables;

            public void modelMatched() {
                this.variables = new LinkedHashMap();
                frameCreationContext.beginNew(this.variables);
            }

            public void modelSubmitted(WindupVertexFrame model) {
                Maps.addListValue(this.variables, (Object)JavaClass.this.getVarname(), (Object)model);
            }

            public void modelSubmissionRejected() {
                frameCreationContext.rollback();
            }
        });
    }

    protected boolean evaluateWithValueStore(GraphRewrite event, EvaluationContext context, FrameContext frameContext) {
        boolean result = this.evaluate(event, context, (EvaluationStrategy)new NoopEvaluationStrategy());
        if (!result) {
            frameContext.reject();
        }
        return result;
    }

    private String titanify(Pattern pattern) {
        return pattern.pattern().replace("\\Q", "\"").replace("\\E", "\"").replace("?:", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluate(GraphRewrite event, EvaluationContext context, EvaluationStrategy evaluationStrategy) {
        try {
            ExecutionStatistics.get().begin("JavaClass.evaluate");
            ParameterStore store = DefaultParameterStore.getInstance((EvaluationContext)context);
            final Pattern compiledPattern = this.referencePattern.getCompiledPattern(store);
            String initialQueryID = null;
            initialQueryID = "iqi." + UUID.randomUUID().toString();
            if (!StringUtils.isBlank((String)this.getInputVariablesName())) {
                QueryBuilderFrom fromQuery = Query.from((String)this.getInputVariablesName());
                QueryBuilderPiped piped = fromQuery.piped(new QueryGremlinCriterion(){

                    public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                        pipeline.out(new String[]{"file"}).in(new String[]{"file"}).has("resolvedSourceSnippit", (Predicate)Text.REGEX, (Object)compiledPattern.toString());
                    }
                });
                piped.as(initialQueryID).evaluate((Rewrite)event, context);
            } else {
                GremlinPipeline resolvedTextSearch = new GremlinPipeline((Object)event.getGraphContext().getGraph());
                resolvedTextSearch.V();
                resolvedTextSearch.has("resolvedSourceSnippit", (Predicate)Text.REGEX, (Object)this.titanify(compiledPattern));
                if (!resolvedTextSearch.iterator().hasNext()) {
                    boolean piped = false;
                    return piped;
                }
                Variables.instance((GraphRewrite)event).setVariable(initialQueryID, (Iterable)new FramedVertexIterable(event.getGraphContext().getFramed(), (Iterable)resolvedTextSearch, JavaTypeReferenceModel.class));
            }
            QueryBuilderFrom query = Query.from((String)initialQueryID);
            if (this.lineMatchPattern != null) {
                Pattern compiledLineMatchPattern = this.lineMatchPattern.getCompiledPattern(store);
                query.withProperty("referenceSourceSnippit", QueryPropertyComparisonType.REGEX, (Object)compiledLineMatchPattern.pattern());
            }
            String uuid = UUID.randomUUID().toString();
            query.as(uuid);
            if (this.typeFilterPattern != null) {
                Pattern compiledTypeFilterPattern = this.typeFilterPattern.getCompiledPattern(store);
                query.piped((QueryGremlinCriterion)new TypeFilterCriterion(compiledTypeFilterPattern));
            }
            if (!this.locations.isEmpty()) {
                query.withProperty("referenceType", this.locations);
            }
            ArrayList<JavaTypeReferenceModel> results = new ArrayList<JavaTypeReferenceModel>();
            if (query.evaluate((Rewrite)event, context)) {
                Iterable frames = Variables.instance((GraphRewrite)event).findVariable(uuid);
                for (WindupVertexFrame frame : frames) {
                    FileModel fileModel = ((FileReferenceModel)frame).getFile();
                    Iterable<JavaClassModel> javaClasses = null;
                    if (fileModel instanceof AbstractJavaSourceModel) {
                        javaClasses = ((AbstractJavaSourceModel)fileModel).getJavaClasses();
                    } else if (fileModel instanceof JavaClassFileModel) {
                        javaClasses = Arrays.asList(((JavaClassFileModel)fileModel).getJavaClass());
                    }
                    for (JavaClassModel javaClassModel : javaClasses) {
                        JavaTypeReferenceModel model;
                        ParameterizedPatternResult referenceResult;
                        if (this.typeFilterPattern != null && !this.typeFilterPattern.parse(javaClassModel.getQualifiedName()).matches() || !(referenceResult = this.referencePattern.parse((model = (JavaTypeReferenceModel)frame).getResolvedSourceSnippit())).matches()) continue;
                        evaluationStrategy.modelMatched();
                        if (referenceResult.submit((Rewrite)event, context) && (this.typeFilterPattern == null || this.typeFilterPattern.parse(javaClassModel.getQualifiedName()).submit((Rewrite)event, context))) {
                            results.add(model);
                            evaluationStrategy.modelSubmitted((WindupVertexFrame)model);
                            continue;
                        }
                        evaluationStrategy.modelSubmissionRejected();
                    }
                }
                Variables.instance((GraphRewrite)event).removeVariable(uuid);
                if (initialQueryID != null) {
                    Variables.instance((GraphRewrite)event).removeVariable(initialQueryID);
                }
                this.setResults(event, this.getVarname(), results);
                boolean bl = !results.isEmpty();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ExecutionStatistics.get().end("JavaClass.evaluate");
        }
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>(this.referencePattern.getRequiredParameterNames());
        if (this.typeFilterPattern != null) {
            result.addAll(this.typeFilterPattern.getRequiredParameterNames());
        }
        if (this.lineMatchPattern != null) {
            result.addAll(this.lineMatchPattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.locations != null && !this.locations.isEmpty()) {
            TypeInterestFactory.registerInterest(this.uniqueID, this.referencePattern.getCompiledPattern(store).pattern(), this.referencePattern.getPattern(), this.locations);
        } else {
            TypeInterestFactory.registerInterest(this.uniqueID, this.referencePattern.getCompiledPattern(store).pattern(), this.referencePattern.getPattern(), new TypeReferenceLocation[0]);
        }
        this.referencePattern.setParameterStore(store);
        if (this.typeFilterPattern != null) {
            this.typeFilterPattern.setParameterStore(store);
        }
    }

    public String getVarname() {
        return this.getOutputVariablesName();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JavaClass");
        if (this.typeFilterPattern != null) {
            builder.append(".inType(" + this.typeFilterPattern + ")");
        }
        if (this.referencePattern != null) {
            builder.append(".references(" + this.referencePattern + ")");
        }
        if (!this.locations.isEmpty()) {
            builder.append(".at(" + this.locations + ")");
        }
        builder.append(".as(" + this.getVarname() + ")");
        return builder.toString();
    }

    public RegexParameterizedPatternParser getReferences() {
        return this.referencePattern;
    }

    public RegexParameterizedPatternParser getMatchesSource() {
        return this.lineMatchPattern;
    }

    public List<TypeReferenceLocation> getLocations() {
        return this.locations;
    }

    public RegexParameterizedPatternParser getTypeFilterRegex() {
        return this.typeFilterPattern;
    }

    private final class TypeFilterCriterion
    implements QueryGremlinCriterion {
        private final Pattern compiledTypeFilterPattern;

        private TypeFilterCriterion(Pattern compiledTypeFilterPattern) {
            this.compiledTypeFilterPattern = compiledTypeFilterPattern;
        }

        public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
            Predicate regexPredicate = new Predicate(){

                public boolean evaluate(Object first, Object second) {
                    return ((String)first).matches((String)second);
                }
            };
            pipeline.as("result").out(new String[]{"file"}).out(new String[]{"javaClass"}).has("qualifiedName", regexPredicate, (Object)this.compiledTypeFilterPattern.pattern()).back("result");
        }
    }
}

