/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.reporting.freemarker;

import freemarker.core.Environment;
import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerTemplateDirective;
import org.jboss.windup.reporting.model.association.LinkableModel;

public class LinkableDirective
implements WindupFreeMarkerTemplateDirective {
    public static final String RENDER_LINKABLE = "render_linkable";

    public String getDescription() {
        return "Takes the following parameters: LinkableModel (a " + LinkableModel.class.getSimpleName() + ")";
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        Writer writer = env.getOut();
        StringModel projectStringModel = (StringModel)params.get("linkable");
        Object obj = projectStringModel.getWrappedObject();
        if (!(obj instanceof LinkableModel)) {
            return;
        }
        LayoutType layoutType = LayoutType.HORIZONTAL;
        SimpleScalar layoutModel = (SimpleScalar)params.get("layout");
        if (layoutModel != null) {
            String layoutParam = layoutModel.getAsString();
            try {
                layoutType = LayoutType.valueOf(layoutParam.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new TemplateException("Layout: " + layoutParam + " is not supported.", (Exception)e, null);
            }
        }
        LinkableModel linkable = (LinkableModel)obj;
        switch (layoutType) {
            case UL: {
                this.renderAsUL(writer, linkable);
                break;
            }
            case LI: {
                this.renderAsLI(writer, linkable);
                break;
            }
            case DL: {
                this.renderAsDL(writer, linkable);
                break;
            }
            case DT: {
                this.renderAsDT(writer, linkable);
                break;
            }
            default: {
                this.renderAsHorizontal(writer, linkable);
            }
        }
    }

    private void renderAsUL(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        if (links.hasNext()) {
            writer.append("<ul>");
            this.renderAsLI(writer, linkable);
            writer.append("</ul>");
        }
    }

    private void renderAsLI(Writer writer, LinkableModel linkable) throws IOException {
        for (LinkModel link : linkable.getLinks()) {
            writer.append("<li>");
            this.renderLink(writer, link);
            writer.append("</li>");
        }
    }

    private void renderAsDL(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        if (links.hasNext()) {
            writer.append("<dl>");
            this.renderAsDT(writer, linkable);
            writer.append("</dl>");
        }
    }

    private void renderAsDT(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        if (links.hasNext()) {
            while (links.hasNext()) {
                LinkModel link = (LinkModel)links.next();
                writer.append("<dt>");
                writer.append(link.getDescription());
                writer.append("</dt>");
                writer.append("<dd>");
                writer.append("<a href='" + link.getLink() + "'>Link</a>");
                writer.append("</dd>");
            }
        }
    }

    private void renderAsHorizontal(Writer writer, LinkableModel linkable) throws IOException {
        Iterator links = linkable.getLinks().iterator();
        while (links.hasNext()) {
            LinkModel link = (LinkModel)links.next();
            this.renderLink(writer, link);
            if (!links.hasNext()) continue;
            writer.append(" | ");
        }
    }

    private void renderLink(Writer writer, LinkModel link) throws IOException {
        writer.append("<a href='" + link.getLink() + "'>");
        writer.append(link.getDescription());
        writer.append("</a>");
    }

    public String getDirectiveName() {
        return RENDER_LINKABLE;
    }

    public void setContext(GraphRewrite event) {
    }

    private static enum LayoutType {
        HORIZONTAL,
        UL,
        DL,
        LI,
        DT;

    }
}

