/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.oupls.sail;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class SailLoader {
    private static final Logger LOGGER = Logger.getLogger(SailLoader.class.getName());
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    private static final int DEFAULT_LOGGING_BUFFER_SIZE = 10000;
    private final Sail sail;
    private boolean verbose = false;
    private String baseUri = "http://example.org/baseURI/";
    private int bufferSize = 1000;
    private int loggingBufferSize = 10000;

    public SailLoader(Sail sail) {
        this.sail = sail;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setLoggingBufferSize(int loggingBufferSize) {
        this.loggingBufferSize = loggingBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(File fileOrDirectory) throws Exception {
        LOGGER.info("loading from " + fileOrDirectory);
        SailConnection c = this.sail.getConnection();
        try {
            c.begin();
            long startTime = System.currentTimeMillis();
            long count = this.loadFile(fileOrDirectory, c);
            long endTime = System.currentTimeMillis();
            c.commit();
            LOGGER.info("loaded " + count + " statements in " + (endTime - startTime) + "ms");
        }
        finally {
            c.rollback();
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadFile(File fileOrDirectory, SailConnection c) throws IOException {
        InputStream is;
        RDFFormat format;
        String n;
        if (fileOrDirectory.isDirectory()) {
            long count = 0L;
            for (File child : fileOrDirectory.listFiles()) {
                count += this.loadFile(child, c);
            }
            return count;
        }
        long before = System.currentTimeMillis();
        if (this.verbose) {
            LOGGER.info("loading file: " + fileOrDirectory);
        }
        if ((n = fileOrDirectory.getName()).endsWith(".gz")) {
            String n0 = n.substring(0, n.lastIndexOf("."));
            format = RDFFormat.forFileName((String)n0);
            is = new GZIPInputStream(new FileInputStream(fileOrDirectory));
        } else {
            format = RDFFormat.forFileName((String)n);
            is = new FileInputStream(fileOrDirectory);
        }
        if (null == format) {
            LOGGER.warning("could not guess format of file: " + n);
            return 0L;
        }
        RDFParser p = Rio.createParser((RDFFormat)format);
        p.setStopAtFirstError(false);
        SailConnectionAdder adder = new SailConnectionAdder(c);
        p.setRDFHandler((RDFHandler)adder);
        try {
            p.parse(is, this.baseUri);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            is.close();
        }
        long after = System.currentTimeMillis();
        if (this.verbose) {
            LOGGER.info("\tfinished in " + (after - before) + "ms");
        }
        return adder.count;
    }

    private class SailConnectionAdder
    implements RDFHandler {
        private final SailConnection c;
        private long count = 0L;

        private SailConnectionAdder(SailConnection c) {
            this.c = c;
        }

        public void startRDF() throws RDFHandlerException {
        }

        public void endRDF() throws RDFHandlerException {
            try {
                this.c.commit();
                this.c.begin();
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
            try {
                this.c.setNamespace(prefix, uri);
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
            this.incrementCount();
        }

        public void handleStatement(Statement statement) throws RDFHandlerException {
            try {
                this.c.addStatement(statement.getSubject(), statement.getPredicate(), statement.getObject(), new Resource[]{statement.getContext()});
            }
            catch (SailException e) {
                throw new RDFHandlerException((Throwable)e);
            }
            this.incrementCount();
        }

        public void handleComment(String s) throws RDFHandlerException {
        }

        private void incrementCount() throws RDFHandlerException {
            ++this.count;
            if (0L == this.count % (long)SailLoader.this.bufferSize) {
                try {
                    this.c.commit();
                    this.c.begin();
                    if (SailLoader.this.verbose && 0L == this.count % (long)SailLoader.this.loggingBufferSize) {
                        LOGGER.info("" + System.currentTimeMillis() + "\t" + this.count);
                    }
                }
                catch (SailException e) {
                    throw new RDFHandlerException((Throwable)e);
                }
            }
        }
    }
}

