/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives;

import java.util.logging.Logger;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.observers.AbstractTransferListener;

class LoggingTransferListener
extends AbstractTransferListener {
    private int percent = 0;
    private int progress = 0;
    private Logger log;

    public LoggingTransferListener(Logger log) {
        this.log = log;
    }

    public void transferStarted(TransferEvent transferEvent) {
        this.log.info(transferEvent.getResource().getName() + " download beginning.");
    }

    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        this.progress += length;
        long contentLength = transferEvent.getResource().getContentLength();
        long percentComplete = (long)((double)this.progress * 100.0 / (double)contentLength);
        if ((int)percentComplete / 10 == this.percent) {
            this.log.info(transferEvent.getResource().getName() + " - " + percentComplete + "% (" + this.progress + "/" + contentLength + ")");
            ++this.percent;
        }
    }

    public void transferCompleted(TransferEvent transferEvent) {
        this.log.info(transferEvent.getResource().getName() + " downloaded.");
        this.log.info("Indexing and sorting metadata may take some time...");
    }
}

