/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.archetype;

import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.catalog.io.xpp3.ArchetypeCatalogXpp3Reader;
import org.jboss.forge.addon.maven.archetype.ArchetypeCatalogFactory;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Strings;

class URLArchetypeCatalogFactory
implements ArchetypeCatalogFactory {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String name;
    private final URL catalogURL;
    private final String defaultRepository;
    private ArchetypeCatalog cachedArchetypes;

    public URLArchetypeCatalogFactory(String name, URL catalogURL, String defaultRepository) {
        Assert.notNull((Object)name, (String)"Name should not be null");
        Assert.notNull((Object)catalogURL, (String)"Catalog URL must be specified");
        this.name = name;
        this.catalogURL = catalogURL;
        this.defaultRepository = defaultRepository;
    }

    public URLArchetypeCatalogFactory(String name, URL catalogUrl) {
        this(name, catalogUrl, URLArchetypeCatalogFactory.extractRepository(catalogUrl));
    }

    private static String extractRepository(URL catalog) {
        if (catalog == null) {
            return null;
        }
        String url = catalog.toString();
        int idx = url.lastIndexOf(47);
        if (idx == -1) {
            return null;
        }
        return url.substring(0, idx);
    }

    public String getName() {
        return this.name;
    }

    public ArchetypeCatalog getArchetypeCatalog() {
        if (this.cachedArchetypes == null) {
            try (InputStream urlStream = this.catalogURL.openStream();){
                this.cachedArchetypes = new ArchetypeCatalogXpp3Reader().read(urlStream);
                for (Archetype archetype : this.cachedArchetypes.getArchetypes()) {
                    if (!Strings.isNullOrEmpty((String)archetype.getRepository())) continue;
                    archetype.setRepository(this.defaultRepository);
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while retrieving archetypes", e);
            }
        }
        return this.cachedArchetypes;
    }

    public String toString() {
        return String.valueOf(this.catalogURL);
    }
}

