/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.windup.config.DefaultEvaluationContext;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.config.RuleLifecycleListener;
import org.jboss.windup.config.RuleSubset;
import org.jboss.windup.config.loader.RuleLoader;
import org.jboss.windup.config.metadata.RuleProviderRegistry;
import org.jboss.windup.exec.DefaultRuleLifecycleListener;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.exec.rulefilters.AndPredicate;
import org.jboss.windup.exec.rulefilters.SourceAndTargetPredicate;
import org.jboss.windup.exec.rulefilters.TaggedRuleProviderPredicate;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.TechnologyReferenceModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.config.RuleVisit;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.DefaultParameterValueStore;
import org.ocpsoft.rewrite.param.ParameterValueStore;
import org.ocpsoft.rewrite.util.Visitor;

public class WindupProcessorImpl
implements WindupProcessor {
    private static final Logger LOG = Logging.get(WindupProcessorImpl.class);
    @Inject
    private RuleLoader ruleLoader;
    @Inject
    private Imported<RuleLifecycleListener> listeners;

    public void execute() {
        this.execute(new WindupConfiguration());
    }

    public void execute(WindupConfiguration configuration) {
        long startTime = System.currentTimeMillis();
        this.validateConfig(configuration);
        GraphContext context = configuration.getGraphContext();
        context.setOptions(configuration.getOptionMap());
        WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)context);
        LinkedHashSet<FileModel> inputPathModels = new LinkedHashSet<FileModel>();
        for (Path inputPath : configuration.getInputPaths()) {
            inputPathModels.add(this.getFileModel(context, inputPath));
        }
        configurationModel.setInputPaths(inputPathModels);
        configurationModel.setOutputPath(this.getFileModel(context, configuration.getOutputDirectory()));
        configurationModel.setOfflineMode(configuration.isOffline());
        configurationModel.setExportingCSV(configuration.isExportingCSV());
        configurationModel.setKeepWorkDirectories((Boolean)configuration.getOptionValue("keepWorkDirs"));
        for (Path path : configuration.getAllUserRulesDirectories()) {
            System.out.println("Using user rules dir: " + path);
            if (path == null) {
                throw new WindupException("Null path found (all paths are: " + configuration.getAllUserRulesDirectories() + ")");
            }
            configurationModel.addUserRulesPath(this.getFileModel(context, path));
        }
        for (Path path : configuration.getAllIgnoreDirectories()) {
            configurationModel.addUserIgnorePath(this.getFileModel(context, path));
        }
        this.addSourceAndTargetInformation(context, configuration, configurationModel);
        this.configureRuleProviderAndTagFilters(configuration);
        RuleProviderRegistry providerRegistry = this.ruleLoader.loadConfiguration(context, configuration.getRuleProviderFilter());
        Configuration rules = providerRegistry.getConfiguration();
        ArrayList<RuleLifecycleListener> listeners = new ArrayList<RuleLifecycleListener>();
        for (RuleLifecycleListener listener : this.listeners) {
            listeners.add(listener);
        }
        if (configuration.getProgressMonitor() != null) {
            listeners.add(new DefaultRuleLifecycleListener(configuration.getProgressMonitor(), rules));
        }
        final GraphRewrite event = new GraphRewrite(listeners, context);
        event.getRewriteContext().put(RuleProviderRegistry.class, (Object)providerRegistry);
        RuleSubset ruleSubset = RuleSubset.create((Configuration)rules);
        ruleSubset.setAlwaysHaltOnFailure(configuration.isAlwaysHaltOnException());
        for (RuleLifecycleListener listener : listeners) {
            ruleSubset.addLifecycleListener(listener);
        }
        new RuleVisit((Rule)ruleSubset).accept((Visitor)new Visitor<Rule>(){

            public void visit(Rule r) {
                if (r instanceof PreRulesetEvaluation) {
                    ((PreRulesetEvaluation)r).preRulesetEvaluation(event);
                }
            }
        });
        ruleSubset.perform((Rewrite)event, this.createEvaluationContext());
        long endTime = System.currentTimeMillis();
        long seconds = (endTime - startTime) / 1000L;
        LOG.info("Windup execution took " + seconds + " seconds to execute on input: " + configuration.getInputPaths() + "!");
        ExecutionStatistics.get().reset();
    }

    private void addSourceAndTargetInformation(GraphContext context, WindupConfiguration configuration, WindupConfigurationModel configurationModel) {
        TechnologyReferenceModel technologyReferenceModel;
        Collection sources = (Collection)configuration.getOptionMap().get("source");
        Collection targets = (Collection)configuration.getOptionMap().get("target");
        GraphService technologyReferenceService = new GraphService(context, TechnologyReferenceModel.class);
        if (sources != null) {
            for (String sourceID : sources) {
                technologyReferenceModel = (TechnologyReferenceModel)technologyReferenceService.create();
                technologyReferenceModel.setTechnologyID(sourceID);
                configurationModel.addSourceTechnology(technologyReferenceModel);
            }
        }
        if (targets != null) {
            for (String targetID : targets) {
                technologyReferenceModel = (TechnologyReferenceModel)technologyReferenceService.create();
                technologyReferenceModel.setTechnologyID(targetID);
                configurationModel.addTargetTechnology(technologyReferenceModel);
            }
        }
    }

    private void configureRuleProviderAndTagFilters(WindupConfiguration config) {
        Collection includeTags = (Collection)config.getOptionMap().get("includeTags");
        Collection excludeTags = (Collection)config.getOptionMap().get("excludeTags");
        Collection sources = (Collection)config.getOptionMap().get("source");
        Collection targets = (Collection)config.getOptionMap().get("target");
        if (includeTags != null || excludeTags != null || sources != null || targets != null) {
            Predicate configuredPredicate = config.getRuleProviderFilter();
            TaggedRuleProviderPredicate tagPredicate = new TaggedRuleProviderPredicate(includeTags, excludeTags);
            SourceAndTargetPredicate sourceAndTargetPredicate = new SourceAndTargetPredicate(sources, targets);
            AndPredicate providerFilter = new AndPredicate(new Predicate[]{tagPredicate, sourceAndTargetPredicate});
            if (configuredPredicate != null) {
                providerFilter = new AndPredicate(new Predicate[]{configuredPredicate, tagPredicate, sourceAndTargetPredicate});
            }
            config.setRuleProviderFilter((Predicate)providerFilter);
        }
    }

    private FileModel getFileModel(GraphContext context, Path file) {
        return new FileService(context).createByFilePath(file.toString());
    }

    private EvaluationContext createEvaluationContext() {
        DefaultEvaluationContext evaluationContext = new DefaultEvaluationContext();
        DefaultParameterValueStore values = new DefaultParameterValueStore();
        evaluationContext.put(ParameterValueStore.class, (Object)values);
        return evaluationContext;
    }

    private void validateConfig(WindupConfiguration windupConfiguration) {
        Assert.notNull((Object)windupConfiguration, (String)"Windup configuration must not be null. (Call default execution if no configuration is required.)");
        GraphContext context = windupConfiguration.getGraphContext();
        Assert.notNull((Object)context, (String)"Windup GraphContext must not be null!");
        Collection inputPaths = windupConfiguration.getInputPaths();
        Assert.notNull((Object)inputPaths, (String)"Path to the application must not be null!");
        for (Path inputPath : inputPaths) {
            Assert.notNull((Object)inputPath, (String)"Path to the application must not be null!");
            Checks.checkFileOrDirectoryToBeRead((File)inputPath.toFile(), (String)"Application");
        }
        Path outputDirectory = windupConfiguration.getOutputDirectory();
        Assert.notNull((Object)outputDirectory, (String)"Output directory must not be null!");
        Checks.checkDirectoryToBeFilled((File)outputDirectory.toFile(), (String)"Output directory");
    }
}

