/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.request.RemoveRequest;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.Addons;

public class AddonBuildAndInstallCommand
extends AbstractProjectCommand
implements AddonCommandConstants {
    private UIInput<DirectoryResource> projectRoot;

    public Metadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name(gui ? "Build and Install an Addon" : "addon-build-and-install").description("Command to build and install a Furnace 2 addon.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.projectRoot = (UIInput)((UIInput)((UIInput)factory.createInput("projectRoot", DirectoryResource.class).setLabel("Project directory")).setDescription("The location of the project (contains pom.xml)")).setRequired(true);
        Project project = this.getSelectedProject((UIContextProvider)builder);
        if (project != null) {
            this.projectRoot.setDefaultValue((Object)project.getRoot().reify(DirectoryResource.class));
        }
        builder.add(this.projectRoot);
    }

    public Result execute(UIExecutionContext context) {
        Project project = this.getProjectFactory().findProject((Resource)this.projectRoot.getValue());
        if (project == null) {
            return Results.fail((String)("No project found in root " + ((DirectoryResource)this.projectRoot.getValue()).getFullyQualifiedName()));
        }
        Coordinate coordinate = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getOutputDependency().getCoordinate();
        try {
            ((PackagingFacet)project.getFacet(PackagingFacet.class)).createBuilder().runTests(false).addArguments(new String[]{"clean", "install"}).build();
        }
        catch (BuildException e) {
            return Results.fail((String)"Unable to execute project build", (Throwable)e);
        }
        try {
            AddonManager addonManager = (AddonManager)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), AddonManager.class).get();
            AddonId id = AddonId.from((String)(coordinate.getGroupId() + ":" + coordinate.getArtifactId()), (String)coordinate.getVersion());
            RemoveRequest removeRequest = addonManager.remove(id);
            removeRequest.perform();
            AddonRegistry registry = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader()).getAddonRegistry(new AddonRepository[0]);
            Addons.waitUntilStopped((Addon)registry.getAddon(id));
            InstallRequest installRequest = addonManager.install(id);
            installRequest.perform();
            return Results.success((String)("Addon " + coordinate.toString() + " was installed successfully."));
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + coordinate.toString() + " could not be installed."), (Throwable)t);
        }
    }

    protected boolean isProjectRequired() {
        return false;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

