/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.forge.addon.manager.impl.ui.AddonCommandConstants;
import org.jboss.forge.addon.manager.impl.utils.CoordinateUtils;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.manager.AddonManager;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.manager.spi.Response;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.versions.Versions;

public class AddonUpdateCommand
extends AbstractUICommand
implements AddonCommandConstants {
    private UIInput<String> named;

    public Metadata getMetadata(UIContext context) {
        boolean gui = context.getProvider().isGUI();
        return Metadata.from((UICommandMetadata)super.getMetadata(context), this.getClass()).name(gui ? "Update an Addon" : "addon-update").description("Command to update a Furnace 2 addon. It may end up updating multiple addons.").category(Categories.create((String[])ADDON_MANAGER_CATEGORIES));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        final Furnace furnace = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader());
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.named = (UIInput)((UIInput)((UIInput)factory.createInput("named", String.class).setLabel("Name")).setDescription("The addon's \"groupId:artifactId\" name")).setRequired(true);
        this.named.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                TreeSet<String> items = new TreeSet<String>();
                Set addons = furnace.getAddonRegistry(new AddonRepository[0]).getAddons();
                for (Addon addon : addons) {
                    if (!addon.getId().toCoordinates().startsWith(value)) continue;
                    items.add(addon.getId().getName());
                }
                return items;
            }
        });
        this.named.addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                String coordinate = (String)context.getCurrentInputComponent().getValue();
                try {
                    Set addons = furnace.getAddonRegistry(new AddonRepository[0]).getAddons();
                    boolean match = false;
                    for (Addon addon : addons) {
                        if (!addon.getId().getName().equals(coordinate)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        context.addValidationError(context.getCurrentInputComponent(), "\"" + coordinate + "\" does not refer to any installed Addon coordinate.");
                    }
                }
                catch (IllegalArgumentException e) {
                    context.addValidationError(context.getCurrentInputComponent(), "\"" + coordinate + "\" is not a valid Addon coordinate");
                }
            }
        });
        builder.add(this.named);
    }

    public Result execute(UIExecutionContext context) {
        AddonId addonId;
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)this.getClass().getClassLoader());
        AddonManager addonManager = (AddonManager)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), AddonManager.class).get();
        AddonDependencyResolver resolver = (AddonDependencyResolver)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), AddonDependencyResolver.class).get();
        AddonId maxAddonId = addonId = CoordinateUtils.resolveCoordinate((String)this.named.getValue(), Versions.getSpecificationVersionFor(this.getClass()), resolver);
        try {
            Response resolveVersions = resolver.resolveVersions(addonId.getName());
            for (AddonId id : (AddonId[])resolveVersions.get()) {
                if (id.getVersion().compareTo((Object)maxAddonId.getVersion()) <= 0) continue;
                maxAddonId = id;
            }
            for (AddonRepository r : furnace.getRepositories()) {
                List listEnabled = r.listEnabled();
                for (AddonId id : listEnabled) {
                    if (!id.equals((Object)maxAddonId)) continue;
                    return Results.fail((String)("Addon " + maxAddonId.toCoordinates() + " is already installed with the most updated version."));
                }
            }
            InstallRequest installRequest = addonManager.install(maxAddonId);
            if (installRequest.getActions().isEmpty()) {
                return Results.fail((String)("Addon " + maxAddonId.toCoordinates() + " is already installed with the most updated version."));
            }
            UIPrompt prompt = context.getPrompt();
            if (prompt.promptBoolean(installRequest.toString() + "\n Do you want to proceed?")) {
                installRequest.perform();
                return Results.success((String)("Addon " + maxAddonId.toCoordinates() + " was installed successfully."));
            }
            return Results.fail((String)"Addon update aborted.");
        }
        catch (Throwable t) {
            return Results.fail((String)("Addon " + maxAddonId.toCoordinates() + " could not be installed."), (Throwable)t);
        }
    }
}

