/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.manager.impl.ui.update;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.dependencies.util.CompositeDependencyFilter;
import org.jboss.forge.addon.dependencies.util.NonSnapshotDependencyFilter;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.zip.ZipFileResource;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class ForgeUpdateCommand
extends AbstractUICommand {
    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        DependencyResolver resolver = (DependencyResolver)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), DependencyResolver.class).get();
        UIProvider provider = context.getUIContext().getProvider();
        UIOutput output = provider.getOutput();
        UIPrompt prompt = context.getPrompt();
        PrintStream out = output.out();
        DirectoryResource forgeHome = this.getForgeHome();
        DirectoryResource updateDir = forgeHome.getChildDirectory(".update");
        if (updateDir.exists()) {
            return Results.fail((String)"There is an update pending. Restart Forge for the update to take effect. To abort this update, type 'forge-update-abort'");
        }
        Coordinate forgeDistribution = this.getLatestAvailableDistribution(resolver);
        if (forgeDistribution == null) {
            output.info(out, "Forge is up to date! Enjoy!");
        } else {
            output.info(out, "This Forge installation will be updated to " + forgeDistribution.getVersion());
            if (prompt.promptBoolean("Is that ok ?", true)) {
                this.updateForge(forgeHome, forgeDistribution, output);
            }
        }
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        UIProvider provider = context.getProvider();
        return !provider.isEmbedded() && !provider.isGUI();
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Forge: Update").description("Update this forge installation").category(Categories.create((String[])new String[]{"Forge", "Manage"}));
    }

    private DirectoryResource getForgeHome() {
        ResourceFactory resourceFactory = (ResourceFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ResourceFactory.class).get();
        DirectoryResource forgeHome = (DirectoryResource)resourceFactory.create(DirectoryResource.class, (Object)OperatingSystemUtils.getForgeHomeDir());
        return forgeHome;
    }

    private void updateForge(DirectoryResource forgeHome, Coordinate forgeDistribution, UIOutput output) throws IOException {
        DependencyResolver resolver = (DependencyResolver)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), DependencyResolver.class).get();
        ResourceFactory resourceFactory = (ResourceFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ResourceFactory.class).get();
        Dependency dependency = resolver.resolveArtifact((DependencyQuery)DependencyQueryBuilder.create((Coordinate)forgeDistribution));
        Assert.notNull((Object)dependency, (String)"Artifact was not found");
        ZipFileResource dependencyZip = (ZipFileResource)resourceFactory.create(ZipFileResource.class, dependency.getArtifact().getUnderlyingResourceObject());
        dependencyZip.extractTo(forgeHome);
        DirectoryResource childDirectory = forgeHome.getChildDirectory(dependency.getCoordinate().getArtifactId() + "-" + dependency.getCoordinate().getVersion());
        DirectoryResource updateDirectory = forgeHome.getChildDirectory(".update");
        childDirectory.renameTo((FileResource)updateDirectory);
        output.success(output.out(), "Forge will now restart to complete the update...");
        System.exit(0);
    }

    private Coordinate getLatestAvailableDistribution(DependencyResolver resolver) {
        final Version runtimeVersion = Versions.getImplementationVersionFor(((Object)((Object)this)).getClass());
        CoordinateBuilder distCoordinate = CoordinateBuilder.create().setGroupId("org.jboss.forge").setArtifactId("forge-distribution").setClassifier("offline").setPackaging("zip");
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Coordinate)distCoordinate).setFilter((Predicate)new CompositeDependencyFilter(new Predicate[]{new NonSnapshotDependencyFilter(), new Predicate<Dependency>(){

            public boolean accept(Dependency dependency) {
                SingleVersion version = SingleVersion.valueOf((String)dependency.getCoordinate().getVersion());
                return version.compareTo((Object)runtimeVersion) > 0 && version.getMajorVersion() == runtimeVersion.getMajorVersion() && "Final".equals(version.getQualifier());
            }
        }}));
        List versions = resolver.resolveVersions((DependencyQuery)query);
        return versions.isEmpty() ? null : (Coordinate)versions.get(versions.size() - 1);
    }
}

