/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.projects.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectProvider;
import org.jboss.forge.addon.projects.ProjectType;
import org.jboss.forge.addon.projects.ProvidedProjectFacet;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.ui.NewProjectWizard;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.SingleValued;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class NewProjectWizardImpl
implements UIWizard,
NewProjectWizard {
    private static final Logger log = Logger.getLogger(NewProjectWizardImpl.class.getName());
    private UIInput<String> named;
    private UIInput<String> topLevelPackage;
    private UIInput<String> version;
    private UIInput<String> finalName;
    private UIInput<DirectoryResource> targetLocation;
    private UIInput<Boolean> overwrite;
    private UISelectOne<ProjectType> type;
    private UISelectOne<ProjectProvider> buildSystem;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(this.getClass()).name("Project: New").description("Create a new project").category(Categories.create((String[])new String[]{"Project", "Generation"}));
    }

    public boolean isEnabled(UIContext context) {
        return !SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectProvider.class).isUnsatisfied();
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext uiContext = builder.getUIContext();
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.configureProjectNamedInput(factory);
        this.configureTopLevelPackageInput(factory);
        this.configureVersionInput(factory);
        this.configureFinalName(factory);
        this.configureTargetLocationInput(factory, uiContext);
        this.configureOverwriteInput(factory);
        this.configureBuildSystemInput(factory, uiContext);
        this.configureProjectTypeInput(factory, uiContext);
        builder.add(this.named).add(this.topLevelPackage).add(this.version).add(this.finalName).add(this.targetLocation).add(this.overwrite).add(this.type).add(this.buildSystem);
    }

    private void configureFinalName(InputComponentFactory factory) {
        this.finalName = (UIInput)factory.createInput("finalName", String.class).setLabel("Final name");
    }

    private void configureProjectNamedInput(InputComponentFactory factory) {
        this.named = (UIInput)((UIInput)factory.createInput("named", String.class).setLabel("Project name")).setRequired(true);
        this.named.addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                if (NewProjectWizardImpl.this.named.getValue() != null && ((String)NewProjectWizardImpl.this.named.getValue()).matches(".*[^-_.a-zA-Z0-9].*")) {
                    context.addValidationError((InputComponent)NewProjectWizardImpl.this.named, "Project name must not contain spaces or special characters.");
                }
            }
        });
    }

    private void configureVersionInput(InputComponentFactory factory) {
        this.version = (UIInput)factory.createInput("version", String.class).setLabel("Version");
        this.version.setDefaultValue((Object)"1.0.0-SNAPSHOT");
    }

    private void configureTargetLocationInput(InputComponentFactory factory, UIContext uiContext) {
        Resource resource;
        this.targetLocation = (UIInput)factory.createInput("targetLocation", DirectoryResource.class).setLabel("Project location");
        UISelection currentSelection = uiContext.getInitialSelection();
        if (!currentSelection.isEmpty() && (resource = (Resource)currentSelection.get()) instanceof DirectoryResource) {
            this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
        }
        if (!this.targetLocation.hasDefaultValue()) {
            ResourceFactory resourceFactory = (ResourceFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ResourceFactory.class).get();
            this.targetLocation.setDefaultValue((Object)resourceFactory.create(DirectoryResource.class, (Object)OperatingSystemUtils.getUserHomeDir()));
        }
    }

    private void configureOverwriteInput(InputComponentFactory factory) {
        this.overwrite = (UIInput)factory.createInput("overwrite", Boolean.class).setLabel("Overwrite existing project location");
        ((UIInput)this.overwrite.setDefaultValue((Object)false)).setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String projectName = (String)NewProjectWizardImpl.this.named.getValue();
                return NewProjectWizardImpl.this.targetLocation.getValue() != null && projectName != null && ((DirectoryResource)NewProjectWizardImpl.this.targetLocation.getValue()).getChild(projectName).exists() && !((DirectoryResource)NewProjectWizardImpl.this.targetLocation.getValue()).getChild(projectName).listResources().isEmpty();
            }
        });
    }

    private void configureProjectTypeInput(InputComponentFactory factory, UIContext uiContext) {
        this.type = (UISelectOne)((UISelectOne)factory.createSelectOne("type", ProjectType.class).setLabel("Project type")).setRequired(true);
        if (uiContext.getProvider().isGUI()) {
            this.type.setItemLabelConverter((Converter)new Converter<ProjectType, String>(){

                public String convert(ProjectType source) {
                    return source == null ? null : source.getType();
                }
            });
        }
        ArrayList<ProjectType> projectTypes = new ArrayList<ProjectType>();
        for (ProjectType projectType : this.type.getValueChoices()) {
            boolean buildable = false;
            for (ProjectProvider buildSystem : SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectProvider.class)) {
                if (!projectType.isEnabled(uiContext) || !this.isProjectTypeBuildable(projectType, buildSystem)) continue;
                projectTypes.add(projectType);
                buildable = true;
                break;
            }
            if (buildable || !log.isLoggable(Level.FINE)) continue;
            log.log(Level.FINE, "ProjectType [" + projectType.getType() + "] " + "deactivated because it cannot be built with any registered ProjectProvider instances [" + SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectProvider.class) + "].");
        }
        Collections.sort(projectTypes, new Comparator<ProjectType>(){

            @Override
            public int compare(ProjectType left, ProjectType right) {
                return new Integer(left.priority()).compareTo(right.priority());
            }
        });
        if (!projectTypes.isEmpty()) {
            this.type.setDefaultValue(projectTypes.get(0));
        }
        this.type.setValueChoices(projectTypes);
    }

    private void configureTopLevelPackageInput(InputComponentFactory factory) {
        this.topLevelPackage = (UIInput)factory.createInput("topLevelPackage", String.class).setLabel("Top level package");
        this.topLevelPackage.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String result = (String)NewProjectWizardImpl.this.named.getValue();
                if (result != null) {
                    result = ("org." + result).replaceAll("\\W+", ".");
                    result = result.trim();
                    result = result.replaceAll("^\\.", "");
                    result = result.replaceAll("\\.$", "");
                } else {
                    result = "org.example";
                }
                return result;
            }
        });
    }

    private void configureBuildSystemInput(InputComponentFactory factory, final UIContext uiContext) {
        final Imported buildSystems = SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectProvider.class);
        this.buildSystem = (UISelectOne)((UISelectOne)factory.createSelectOne("buildSystem", ProjectProvider.class).setLabel("Build system")).setRequired(true);
        this.buildSystem.setItemLabelConverter((Converter)new Converter<ProjectProvider, String>(){

            public String convert(ProjectProvider source) {
                return source == null ? null : source.getType();
            }
        });
        this.buildSystem.setValueChoices((Callable)new Callable<Iterable<ProjectProvider>>(){

            @Override
            public Iterable<ProjectProvider> call() throws Exception {
                ArrayList<ProjectProvider> result = new ArrayList<ProjectProvider>();
                for (ProjectProvider buildSystemType : buildSystems) {
                    ProjectType projectType = (ProjectType)NewProjectWizardImpl.this.type.getValue();
                    if (projectType != null) {
                        if (!projectType.isEnabled(uiContext) || !NewProjectWizardImpl.this.isProjectTypeBuildable(projectType, buildSystemType)) continue;
                        result.add(buildSystemType);
                        continue;
                    }
                    result.add(buildSystemType);
                }
                Collections.sort(result, new Comparator<ProjectProvider>(){

                    @Override
                    public int compare(ProjectProvider left, ProjectProvider right) {
                        return new Integer(left.priority()).compareTo(right.priority());
                    }
                });
                return result;
            }
        });
        this.buildSystem.setDefaultValue((Callable)new Callable<ProjectProvider>(){

            @Override
            public ProjectProvider call() throws Exception {
                Iterator iterator = NewProjectWizardImpl.this.buildSystem.getValueChoices().iterator();
                if (iterator.hasNext()) {
                    return (ProjectProvider)iterator.next();
                }
                return null;
            }
        });
    }

    private boolean isProjectTypeBuildable(ProjectType type, ProjectProvider buildSystem) {
        boolean result = false;
        Iterable<Class<? extends ProvidedProjectFacet>> requiredFacets = this.getRequiredBuildSystemFacets(type);
        if (requiredFacets == null || !requiredFacets.iterator().hasNext()) {
            result = true;
        } else {
            for (Class<? extends ProvidedProjectFacet> required : requiredFacets) {
                result = false;
                for (Class provided : buildSystem.getProvidedFacetTypes()) {
                    if (!provided.isAssignableFrom(required)) continue;
                    result = true;
                }
                if (result) continue;
                break;
            }
        }
        return result;
    }

    private Iterable<Class<? extends ProvidedProjectFacet>> getRequiredBuildSystemFacets(ProjectType type) {
        HashSet<Class<? extends ProvidedProjectFacet>> result = new HashSet<Class<? extends ProvidedProjectFacet>>();
        Iterable requiredFacets = type.getRequiredFacets();
        if (requiredFacets != null) {
            for (Class facetType : requiredFacets) {
                if (!ProvidedProjectFacet.class.isAssignableFrom(facetType)) continue;
                result.add(facetType);
            }
        }
        return result;
    }

    public void validate(UIValidationContext context) {
        String packg = (String)this.topLevelPackage.getValue();
        if (packg != null && !packg.matches("(?i)(~\\.)?([a-z0-9_]+\\.?)+[a-z0-9_]")) {
            context.addValidationError(this.topLevelPackage, "Top level package must be a valid package name.");
        }
        if (this.overwrite.isEnabled() && !((Boolean)this.overwrite.getValue()).booleanValue()) {
            String errorMessage = String.format("Project location '%s' is not empty.", ((DirectoryResource)this.targetLocation.getValue()).getChild((String)this.named.getValue()));
            context.addValidationError(this.targetLocation, errorMessage);
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Result result = Results.success((String)("Project named '" + (String)this.named.getValue() + "' has been created."));
        DirectoryResource directory = (DirectoryResource)this.targetLocation.getValue();
        DirectoryResource targetDir = directory.getChildDirectory((String)this.named.getValue());
        if (targetDir.mkdirs() || ((Boolean)this.overwrite.getValue()).booleanValue()) {
            ProjectType value = (ProjectType)this.type.getValue();
            ProjectFactory projectFactory = (ProjectFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectFactory.class).get();
            Project project = projectFactory.createProject((Resource)targetDir, (ProjectProvider)this.buildSystem.getValue());
            if (project != null) {
                Iterable requiredFacets;
                UIContext uiContext = context.getUIContext();
                MetadataFacet metadataFacet = (MetadataFacet)project.getFacet(MetadataFacet.class);
                metadataFacet.setProjectName((String)this.named.getValue());
                metadataFacet.setProjectVersion((String)this.version.getValue());
                metadataFacet.setProjectGroupName((String)this.topLevelPackage.getValue());
                PackagingFacet packagingFacet = (PackagingFacet)project.getFacet(PackagingFacet.class);
                if (this.finalName.hasValue()) {
                    packagingFacet.setFinalName((String)this.finalName.getValue());
                } else {
                    packagingFacet.setFinalName((String)this.named.getValue());
                }
                if (value != null && (requiredFacets = value.getRequiredFacets()) != null) {
                    FacetFactory facetFactory = (FacetFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), FacetFactory.class).get();
                    for (Class facet : requiredFacets) {
                        if (project.hasFacet(facet)) continue;
                        facetFactory.install((Faceted)project, facet);
                    }
                }
                uiContext.setSelection((Object)project.getRoot());
                uiContext.getAttributeMap().put(Project.class, project);
            } else {
                result = Results.fail((String)("Could not create project of type: [" + value + "]"));
            }
        } else {
            result = Results.fail((String)("Could not create target location: " + targetDir));
        }
        return result;
    }

    public UIInput<String> getNamed() {
        return this.named;
    }

    public UIInput<DirectoryResource> getTargetLocation() {
        return this.targetLocation;
    }

    public UIInput<Boolean> getOverwrite() {
        return this.overwrite;
    }

    public UISelectOne<ProjectType> getType() {
        return this.type;
    }

    public SingleValued<UIInput<String>, String> getTopLevelPackage() {
        return this.topLevelPackage;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        if (this.type.getValue() != null) {
            return Results.navigateTo((Class)((ProjectType)this.type.getValue()).getSetupFlow());
        }
        return null;
    }
}

