/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.exec.updater;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyException;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.maven.resources.MavenModelResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.ZipUtil;
import org.jboss.windup.util.exception.WindupException;

public class RulesetsUpdater {
    private static final Logger log = Logger.getLogger(RulesetsUpdater.class.getName());
    private static final String RULESETS_ARTIFACT_ID = "windup-rulesets";
    private static final String RULES_GROUP_ID = "org.jboss.windup.rules";
    public static final String RULESET_CORE_DIRECTORY = "migration-core";
    @Inject
    private Furnace furnace;
    @Inject
    private DependencyResolver depsResolver;
    @Inject
    ResourceFactory factory;

    public boolean rulesetsNeedUpdate() {
        Coordinate lastRelease = this.getLatestReleaseOf(RULES_GROUP_ID, RULESETS_ARTIFACT_ID);
        Path windupRulesDir = this.getRulesetsDir();
        Path coreRulesPomPath = windupRulesDir.resolve("migration-core/META-INF/maven/org.jboss.windup.rules/windup-rulesets/pom.xml");
        File pomXml = coreRulesPomPath.toFile();
        if (!pomXml.exists()) {
            return false;
        }
        MavenModelResource pom = (MavenModelResource)this.factory.create((Object)pomXml);
        SingleVersion installed = new SingleVersion(pom.getCurrentModel().getVersion());
        SingleVersion latest = new SingleVersion(lastRelease.getVersion());
        String msg = "Core rulesets: Installed: " + installed + " Latest release: " + latest;
        log.info(msg);
        System.out.println(msg);
        return 0 > installed.compareTo((Version)latest);
    }

    public Path getRulesetsDir() {
        Path windupRulesDir = PathUtil.getWindupRulesDir();
        return windupRulesDir;
    }

    public String replaceRulesetsDirectoryWithLatestReleaseIfAny() throws IOException, DependencyException {
        if (!this.rulesetsNeedUpdate()) {
            return null;
        }
        Path windupRulesDir = this.getRulesetsDir();
        Path coreRulesetsDir = windupRulesDir.resolve(RULESET_CORE_DIRECTORY);
        Coordinate rulesetsCoord = this.getLatestReleaseOf(RULES_GROUP_ID, RULESETS_ARTIFACT_ID);
        if (rulesetsCoord == null) {
            throw new WindupException("No Windup release found.");
        }
        FileUtils.deleteDirectory((File)coreRulesetsDir.toFile());
        this.extractArtifact(rulesetsCoord, coreRulesetsDir.toFile());
        return rulesetsCoord.getVersion();
    }

    public void extractArtifact(Coordinate artifactCoords, File targetDir) throws IOException, DependencyException {
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Coordinate)artifactCoords);
        Dependency dependency = this.depsResolver.resolveArtifact((DependencyQuery)query);
        FileResource artifact = dependency.getArtifact();
        ZipUtil.unzipToFolder((File)new File(artifact.getFullyQualifiedName()), (File)targetDir);
    }

    public Coordinate getLatestReleaseOf(String groupId, String artifactId) {
        CoordinateBuilder coord = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        return this.getLatestReleaseOf(coord);
    }

    public Coordinate getLatestReleaseOf(CoordinateBuilder coord) {
        List availableVersions = this.depsResolver.resolveVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)coord));
        for (int i = availableVersions.size() - 1; i >= 0; --i) {
            if (((Coordinate)availableVersions.get(i)).isSnapshot()) continue;
            return (Coordinate)availableVersions.get(i);
        }
        return null;
    }
}

