/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.inferencer.fc;

import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.HashSet;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.sail.NotifyingSail;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.NotifyingSailWrapper;
import org.openrdf.sail.inferencer.InferencerConnection;
import org.openrdf.sail.inferencer.InferencerConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectTypeHierarchyInferencer
extends NotifyingSailWrapper {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final ParsedGraphQuery DIRECT_SUBCLASSOF_MATCHER;
    private static final ParsedGraphQuery DIRECT_SUBCLASSOF_QUERY;
    private static final ParsedGraphQuery DIRECT_SUBPROPERTYOF_MATCHER;
    private static final ParsedGraphQuery DIRECT_SUBPROPERTYOF_QUERY;
    private static final ParsedGraphQuery DIRECT_TYPE_MATCHER;
    private static final ParsedGraphQuery DIRECT_TYPE_QUERY;

    public DirectTypeHierarchyInferencer() {
    }

    public DirectTypeHierarchyInferencer(NotifyingSail baseSail) {
        super(baseSail);
    }

    public InferencerConnection getConnection() throws SailException {
        try {
            InferencerConnection con = (InferencerConnection)super.getConnection();
            return new DirectTypeHierarchyInferencerConnection(con);
        }
        catch (ClassCastException e) {
            throw new SailException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws SailException {
        super.initialize();
        InferencerConnection con = this.getConnection();
        try {
            con.begin();
            con.flushUpdates();
            con.commit();
        }
        finally {
            con.close();
        }
    }

    static {
        try {
            DIRECT_SUBCLASSOF_MATCHER = QueryParserUtil.parseGraphQuery((QueryLanguage)QueryLanguage.SERQL, (String)"CONSTRUCT * FROM {X} sesame:directSubClassOf {Y} ", null);
            DIRECT_SUBPROPERTYOF_MATCHER = QueryParserUtil.parseGraphQuery((QueryLanguage)QueryLanguage.SERQL, (String)"CONSTRUCT * FROM {X} sesame:directType {Y}", null);
            DIRECT_TYPE_MATCHER = QueryParserUtil.parseGraphQuery((QueryLanguage)QueryLanguage.SERQL, (String)"CONSTRUCT * FROM {X} sesame:directSubPropertyOf {Y}", null);
            DIRECT_SUBCLASSOF_QUERY = QueryParserUtil.parseGraphQuery((QueryLanguage)QueryLanguage.SERQL, (String)"CONSTRUCT {X} sesame:directSubClassOf {Y} FROM {X} rdfs:subClassOf {Y} WHERE X != Y AND NOT EXISTS (SELECT Z FROM {X} rdfs:subClassOf {Z} rdfs:subClassOf {Y} WHERE X != Z AND Z != Y)", null);
            DIRECT_SUBPROPERTYOF_QUERY = QueryParserUtil.parseGraphQuery((QueryLanguage)QueryLanguage.SERQL, (String)"CONSTRUCT {X} sesame:directSubPropertyOf {Y} FROM {X} rdfs:subPropertyOf {Y} WHERE X != Y AND NOT EXISTS (SELECT Z FROM {X} rdfs:subPropertyOf {Z} rdfs:subPropertyOf {Y} WHERE X != Z AND Z != Y)", null);
            DIRECT_TYPE_QUERY = QueryParserUtil.parseGraphQuery((QueryLanguage)QueryLanguage.SERQL, (String)"CONSTRUCT {X} sesame:directType {Y} FROM {X} rdf:type {Y} WHERE NOT EXISTS (SELECT Z FROM {X} rdf:type {Z} rdfs:subClassOf {Y} WHERE Z != Y)", null);
        }
        catch (MalformedQueryException e) {
            throw new RuntimeException(e);
        }
    }

    private class DirectTypeHierarchyInferencerConnection
    extends InferencerConnectionWrapper
    implements SailConnectionListener {
        private boolean updateNeeded;

        public DirectTypeHierarchyInferencerConnection(InferencerConnection con) {
            super(con);
            this.updateNeeded = false;
            con.addConnectionListener(this);
        }

        public void statementAdded(Statement st) {
            this.checkUpdatedStatement(st);
        }

        public void statementRemoved(Statement st) {
            this.checkUpdatedStatement(st);
        }

        private void checkUpdatedStatement(Statement st) {
            URI pred = st.getPredicate();
            if (pred.equals((Object)RDF.TYPE) || pred.equals((Object)RDFS.SUBCLASSOF) || pred.equals((Object)RDFS.SUBPROPERTYOF)) {
                this.updateNeeded = true;
            }
        }

        public void rollback() throws SailException {
            super.rollback();
            this.updateNeeded = false;
        }

        @Override
        public void flushUpdates() throws SailException {
            super.flushUpdates();
            while (this.updateNeeded) {
                try {
                    HashSet<Statement> oldStatements = new HashSet<Statement>(256);
                    HashSet<Statement> newStatements = new HashSet<Statement>(256);
                    this.evaluateIntoStatements(DIRECT_SUBCLASSOF_MATCHER, oldStatements);
                    this.evaluateIntoStatements(DIRECT_SUBPROPERTYOF_MATCHER, oldStatements);
                    this.evaluateIntoStatements(DIRECT_TYPE_MATCHER, oldStatements);
                    this.evaluateIntoStatements(DIRECT_SUBCLASSOF_QUERY, newStatements);
                    this.evaluateIntoStatements(DIRECT_SUBPROPERTYOF_QUERY, newStatements);
                    this.evaluateIntoStatements(DIRECT_TYPE_QUERY, newStatements);
                    DirectTypeHierarchyInferencer.this.logger.debug("existing virtual properties: {}", (Object)oldStatements.size());
                    DirectTypeHierarchyInferencer.this.logger.debug("new virtual properties: {}", (Object)newStatements.size());
                    HashSet<Statement> unchangedStatements = new HashSet<Statement>(oldStatements);
                    unchangedStatements.retainAll(newStatements);
                    oldStatements.removeAll(unchangedStatements);
                    newStatements.removeAll(unchangedStatements);
                    DirectTypeHierarchyInferencer.this.logger.debug("virtual properties to remove: {}", (Object)oldStatements.size());
                    DirectTypeHierarchyInferencer.this.logger.debug("virtual properties to add: {}", (Object)newStatements.size());
                    Resource[] contexts = new Resource[]{null};
                    for (Statement st : oldStatements) {
                        this.removeInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    for (Statement st : newStatements) {
                        this.addInferredStatement(st.getSubject(), st.getPredicate(), st.getObject(), contexts);
                    }
                    this.updateNeeded = false;
                }
                catch (RDFHandlerException e) {
                    Throwable t = e.getCause();
                    if (t instanceof SailException) {
                        throw (SailException)t;
                    }
                    throw new SailException(t);
                }
                catch (QueryEvaluationException e) {
                    throw new SailException((Throwable)e);
                }
                super.flushUpdates();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluateIntoStatements(ParsedGraphQuery query, Collection<Statement> statements) throws SailException, RDFHandlerException, QueryEvaluationException {
            CloseableIteration bindingsIter = this.getWrappedConnection().evaluate(query.getTupleExpr(), null, EmptyBindingSet.getInstance(), true);
            try {
                ValueFactory vf = DirectTypeHierarchyInferencer.this.getValueFactory();
                while (bindingsIter.hasNext()) {
                    BindingSet bindings = (BindingSet)bindingsIter.next();
                    Value subj = bindings.getValue("subject");
                    Value pred = bindings.getValue("predicate");
                    Value obj = bindings.getValue("object");
                    if (!(subj instanceof Resource) || !(pred instanceof URI) || obj == null) continue;
                    statements.add(vf.createStatement((Resource)subj, (URI)pred, obj));
                }
            }
            finally {
                bindingsIter.close();
            }
        }
    }
}

