/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.ICapturedType;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeEraser;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeMapper;
import com.strobel.reflection.TypeVisitor;
import java.lang.annotation.Annotation;

final class ErasedType<T>
extends Type<T> {
    static final TypeEraser GenericEraser = new TypeEraser();
    private final Type _originalType;
    private TypeList _interfaces;
    private Type _baseType;
    private FieldList _fields;
    private ConstructorList _constructors;
    private MethodList _methods;
    private TypeList _nestedTypes;
    private static final TypeMapper<Void> UpperBoundMapper = new TypeMapper<Void>(){

        @Override
        public Type<?> visitCapturedType(Type<?> type, Void parameter) {
            return (Type)super.visitCapturedType(((ICapturedType)((Object)type)).getWildcard().getExtendsBound(), parameter);
        }

        @Override
        public Type<?> visitWildcardType(Type<?> type, Void parameter) {
            return (Type)this.visit(type.getExtendsBound());
        }

        @Override
        public Type<?> visitTypeParameter(Type<?> type, Void parameter) {
            return (Type)this.visit(type.getExtendsBound());
        }

        @Override
        public Type<?> visitArrayType(Type<?> type, Void parameter) {
            Type oldElementType = type.getElementType();
            Type newElementType = (Type)this.visit(oldElementType);
            if (newElementType != oldElementType) {
                return newElementType.makeArrayType();
            }
            return type;
        }
    };

    ErasedType(Type baseType) {
        VerifyArgument.notNull((Object)baseType, (String)"baseType");
        this._originalType = baseType.isGenericType() ? baseType.getGenericTypeDefinition() : baseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBaseType() {
        if (this._baseType == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._baseType == null) {
                    Type genericBaseType = this._originalType.getBaseType();
                    this._baseType = genericBaseType == null || genericBaseType == NullType ? NullType : GenericEraser.visit(genericBaseType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInterfaces() {
        if (this._interfaces == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._interfaces == null) {
                    this._interfaces = GenericEraser.visit(this._originalType.getExplicitInterfaces());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFields() {
        if (this._fields == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._fields == null) {
                    this._fields = GenericEraser.visit(this, this._originalType.getFields(BindingFlags.All), TypeBindings.create(this._originalType.getGenericTypeParameters(), UpperBoundMapper.visit(this._originalType.getGenericTypeParameters())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConstructors() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (this._constructors == null) {
                this._constructors = GenericEraser.visit(this, this._originalType.getConstructors(BindingFlags.All), TypeBindings.create(this._originalType.getGenericTypeParameters(), UpperBoundMapper.visit(this._originalType.getGenericTypeParameters())));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMethods() {
        if (this._methods == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._methods == null) {
                    this._methods = GenericEraser.visit(this, this._originalType.getMethods(BindingFlags.All), TypeBindings.create(this._originalType.getGenericTypeParameters(), UpperBoundMapper.visit(this._originalType.getGenericTypeParameters())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNestedTypes() {
        if (this._nestedTypes == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._nestedTypes == null) {
                    this._nestedTypes = GenericEraser.visit(this._originalType.getDeclaredTypes());
                }
            }
        }
    }

    @Override
    public String getName() {
        return this._originalType.getName();
    }

    @Override
    protected String getClassFullName() {
        return this._originalType.getClassFullName();
    }

    @Override
    protected String getClassSimpleName() {
        return this._originalType.getClassSimpleName();
    }

    @Override
    public String getFullName() {
        return this._originalType.getFullName();
    }

    @Override
    public String getInternalName() {
        return this._originalType.getInternalName();
    }

    @Override
    public Class<T> getErasedClass() {
        return this._originalType.getErasedClass();
    }

    @Override
    public TypeList getExplicitInterfaces() {
        this.ensureInterfaces();
        return this._interfaces;
    }

    @Override
    public Type<? super T> getBaseType() {
        this.ensureBaseType();
        Type baseType = this._baseType;
        return baseType == NullType ? null : baseType;
    }

    @Override
    public Type getGenericTypeDefinition() {
        return this._originalType;
    }

    @Override
    public Type getDeclaringType() {
        return this._originalType.getDeclaringType();
    }

    @Override
    public final boolean isGenericType() {
        return false;
    }

    @Override
    public boolean isRawType() {
        return true;
    }

    @Override
    public TypeBindings getTypeBindings() {
        return TypeBindings.empty();
    }

    @Override
    public int getModifiers() {
        return this._originalType.getModifiers();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._originalType.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._originalType.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._originalType.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._originalType.getDeclaredAnnotations();
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> typeVisitor, P parameter) {
        return typeVisitor.visitClassType(this, parameter);
    }

    @Override
    public ConstructorList getDeclaredConstructors() {
        this.ensureConstructors();
        return this._constructors;
    }

    @Override
    protected MethodList getDeclaredMethods() {
        this.ensureMethods();
        return this._methods;
    }

    @Override
    protected FieldList getDeclaredFields() {
        this.ensureFields();
        return this._fields;
    }

    @Override
    protected TypeList getDeclaredTypes() {
        this.ensureNestedTypes();
        return this._nestedTypes;
    }
}

