/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.enterprise.inject.spi.BeanManager;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Scanning;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.xml.BeansXmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class BeansXmlParser {
    private static final InputSource[] EMPTY_INPUT_SOURCE_ARRAY = new InputSource[0];

    public BeansXml parse(URL beansXml) throws DeploymentUnitProcessingException {
        BeansXml beansXml2;
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        factory.setNamespaceAware(true);
        if (beansXml == null) {
            throw new IllegalStateException((Enum)XmlMessage.LOAD_ERROR, new Object[]{"unknown"});
        }
        try {
            parser = factory.newSAXParser();
        }
        catch (SAXException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        InputStream beansXmlInputStream = null;
        try {
            beansXmlInputStream = beansXml.openStream();
            InputSource source = new InputSource(beansXmlInputStream);
            if (source.getByteStream().available() == 0) {
                BeansXml beansXml3 = BeansXml.EMPTY_BEANS_XML;
                return beansXml3;
            }
            BeansXmlHandler handler = new BeansXmlHandler(beansXml);
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", BeansXmlParser.loadXsds());
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            parser.parse(source, (DefaultHandler)handler);
            beansXml2 = handler.createBeansXml();
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException("IOException parsing " + beansXml, (Throwable)e);
        }
        catch (SAXException e) {
            throw new DeploymentUnitProcessingException("SAXException parsing " + beansXml, (Throwable)e);
        }
        finally {
            if (beansXmlInputStream != null) {
                try {
                    beansXmlInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return beansXml2;
    }

    public BeansXml parse(Iterable<URL> urls) throws DeploymentUnitProcessingException {
        ArrayList alternativeStereotypes = new ArrayList();
        ArrayList alternativeClasses = new ArrayList();
        ArrayList decorators = new ArrayList();
        ArrayList interceptors = new ArrayList();
        ArrayList includes = new ArrayList();
        ArrayList excludes = new ArrayList();
        for (URL url : urls) {
            BeansXml beansXml = this.parse(url);
            alternativeStereotypes.addAll(beansXml.getEnabledAlternativeStereotypes());
            alternativeClasses.addAll(beansXml.getEnabledAlternativeClasses());
            decorators.addAll(beansXml.getEnabledDecorators());
            interceptors.addAll(beansXml.getEnabledInterceptors());
            includes.addAll(beansXml.getScanning().getIncludes());
            excludes.addAll(beansXml.getScanning().getExcludes());
        }
        return new BeansXmlImpl(alternativeClasses, alternativeStereotypes, decorators, interceptors, (Scanning)new ScanningImpl(includes, excludes));
    }

    private static InputSource[] loadXsds() {
        ArrayList<InputSource> xsds = new ArrayList<InputSource>();
        InputSource weldXsd = BeansXmlParser.loadXsd("beans_1_1.xsd", BeansXmlParser.class.getClassLoader());
        InputSource cdiXsd = BeansXmlParser.loadXsd("beans_1_0.xsd", BeanManager.class.getClassLoader());
        if (weldXsd != null) {
            xsds.add(weldXsd);
        }
        if (cdiXsd != null) {
            xsds.add(cdiXsd);
        }
        return xsds.toArray(EMPTY_INPUT_SOURCE_ARRAY);
    }

    private static InputSource loadXsd(String name, ClassLoader classLoader) {
        InputStream in = classLoader.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        return new InputSource(in);
    }
}

