/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.analyzers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import org.jboss.tattletale.analyzers.ArchiveScanner;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.profiles.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScanner
implements ArchiveScanner {
    protected List<String> readManifest(Manifest manifest) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            manifest.write(baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            InputStreamReader isr = new InputStreamReader(bais);
            LineNumberReader lnr = new LineNumberReader(isr);
            String s = lnr.readLine();
            while (s != null) {
                result.add(s);
                s = lnr.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected String versionFromManifest(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        String version = mainAttributes.getValue("Specification-Version");
        if (version == null) {
            version = mainAttributes.getValue("Implementation-Version");
        }
        if (version == null) {
            version = mainAttributes.getValue("Version");
        }
        if (version == null && manifest.getEntries() != null) {
            Iterator<Attributes> ait = manifest.getEntries().values().iterator();
            while (version == null && ait.hasNext()) {
                Attributes attributes = ait.next();
                version = attributes.getValue("Specification-Version");
                if (version == null) {
                    version = attributes.getValue("Implementation-Version");
                }
                if (version != null) continue;
                version = attributes.getValue("Version");
            }
        }
        return version;
    }

    protected void addProfilesToArchive(Archive archive, SortedSet<String> profiles) {
        if (profiles.size() > 0) {
            for (String profile : profiles) {
                archive.addProfile(profile);
            }
        }
    }

    public Integer scanClasses(InputStream is, Set<String> blacklisted, List<Profile> known, Integer classVersion, SortedMap<String, Long> provides, SortedSet<String> requires, SortedSet<String> profiles, SortedMap<String, SortedSet<String>> classDependencies, SortedMap<String, SortedSet<String>> packageDependencies, SortedMap<String, SortedSet<String>> blacklistedDependencies) throws IOException {
        ClassPool classPool = new ClassPool();
        CtClass ctClz = classPool.makeClass(is);
        if (classVersion == null) {
            classVersion = ctClz.getClassFile2().getMajorVersion();
        }
        Long serialVersionUID = null;
        try {
            CtField field = ctClz.getField("serialVersionUID");
            serialVersionUID = (Long)field.getConstantValue();
        }
        catch (NotFoundException nfe) {
            // empty catch block
        }
        provides.put(ctClz.getName(), serialVersionUID);
        int pkgIdx = ctClz.getName().lastIndexOf(".");
        String pkg = null;
        if (pkgIdx != -1) {
            pkg = ctClz.getName().substring(0, pkgIdx);
        }
        Collection c = ctClz.getRefClasses();
        for (String s : c) {
            TreeSet<String> bld;
            requires.add(s);
            TreeSet<String> cd = (TreeSet<String>)classDependencies.get(ctClz.getName());
            if (cd == null) {
                cd = new TreeSet<String>();
            }
            cd.add(s);
            classDependencies.put(ctClz.getName(), cd);
            int rPkgIdx = s.lastIndexOf(".");
            String rPkg = null;
            if (rPkgIdx != -1) {
                rPkg = s.substring(0, rPkgIdx);
            }
            boolean include = true;
            if (known != null) {
                Iterator<Profile> kit = known.iterator();
                while (include && kit.hasNext()) {
                    Profile p = kit.next();
                    if (!p.doesProvide(s)) continue;
                    profiles.add(p.getName());
                    include = false;
                }
            }
            if (pkg != null && rPkg != null && !pkg.equals(rPkg) && include) {
                TreeSet<String> pd = (TreeSet<String>)packageDependencies.get(pkg);
                if (pd == null) {
                    pd = new TreeSet<String>();
                }
                pd.add(rPkg);
                packageDependencies.put(pkg, pd);
            }
            if (blacklisted == null) continue;
            boolean bl = false;
            Iterator<String> bit = blacklisted.iterator();
            while (!bl && bit.hasNext()) {
                String blp = bit.next();
                if (!s.startsWith(blp)) continue;
                bl = true;
            }
            if (!bl) continue;
            String key = pkg;
            if (key == null) {
                key = "";
            }
            if ((bld = (TreeSet<String>)blacklistedDependencies.get(key)) == null) {
                bld = new TreeSet<String>();
            }
            bld.add(rPkg);
            blacklistedDependencies.put(key, bld);
        }
        return classVersion;
    }
}

