/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LRUMap;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.rules.apps.java.scan.ast.RewritePatternToRegex;
import org.jboss.windup.rules.apps.java.scan.ast.TypeInterestFactoryTrie;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.Logging;

public final class TypeInterestFactory {
    private static final Logger LOG = Logging.get(TypeInterestFactory.class);
    private static final Map<String, PatternAndLocation> patternsBySource = new HashMap<String, PatternAndLocation>();
    private static final Map<TypeReferenceLocation, TypeInterestFactoryTrie> trieByLocation = new HashMap<TypeReferenceLocation, TypeInterestFactoryTrie>();
    private static final Set<String> ignorePatternSet = Collections.synchronizedSet(new HashSet());
    private static final Map<String, Boolean> resultsCache;
    private static final AtomicLong cacheLookupCount;
    private static final AtomicLong cacheHitCount;
    private static final Set<String> prescanMap;
    private static final AtomicInteger totalPrescans;
    private static final AtomicInteger totalPrescanHits;

    static void clear() {
        patternsBySource.clear();
        trieByLocation.clear();
        resultsCache.clear();
        cacheLookupCount.set(0L);
        cacheHitCount.set(0L);
        prescanMap.clear();
        totalPrescans.set(0);
        totalPrescanHits.set(0);
    }

    public static void registerInterest(String sourceKey, String regex, String rewritePattern, List<TypeReferenceLocation> locations) {
        TypeInterestFactory.registerInterest(sourceKey, regex, rewritePattern, locations.toArray(new TypeReferenceLocation[locations.size()]));
    }

    public static void registerInterest(String sourceKey, String regex, String rewritePattern, TypeReferenceLocation ... locations) {
        patternsBySource.put(sourceKey, new PatternAndLocation(locations, regex, rewritePattern));
    }

    private static String getCacheKey(TypeReferenceLocation location, String text) {
        return location + "_" + text;
    }

    private static Boolean checkCacheForMatches(String inputText, TypeReferenceLocation location) {
        String key = TypeInterestFactory.getCacheKey(location, inputText);
        Boolean cachedResult = resultsCache.get(key);
        Long lookupCount = cacheLookupCount.incrementAndGet();
        Long hitCount = cacheHitCount.get();
        if (cachedResult != null) {
            hitCount = cacheHitCount.incrementAndGet();
        }
        if (lookupCount % 100000L == 0L) {
            long hitPercentage = Math.round((double)hitCount.longValue() / (double)lookupCount.longValue() * 100.0);
            LOG.fine("There have been " + lookupCount + " lookups with " + hitCount + " hits, for a hit percentage of: " + hitPercentage);
        }
        return cachedResult;
    }

    private static TypeInterestFactoryTrie getTrieByLocation(TypeReferenceLocation typeReferenceLocation) {
        TypeInterestFactoryTrie result = trieByLocation.get(typeReferenceLocation);
        if (result == null) {
            result = TypeInterestFactoryTrie.newDefaultInstance();
            for (PatternAndLocation patternKey : patternsBySource.values()) {
                String entryRegex = patternKey.regex;
                TypeReferenceLocation[] entryLocations = patternKey.locations;
                String rewritePattern = patternKey.rewritePattern;
                boolean shouldAdd = false;
                if (entryLocations == null || entryLocations.length == 0) {
                    shouldAdd = true;
                } else {
                    for (TypeReferenceLocation entryLocation : entryLocations) {
                        if (!typeReferenceLocation.equals((Object)entryLocation)) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                result.addInterest(new RewritePatternToRegex(rewritePattern, Pattern.compile(entryRegex)));
            }
            trieByLocation.put(typeReferenceLocation, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean matchesAny(String text, TypeReferenceLocation typeReferenceLocation) {
        ExecutionStatistics.get().begin("TypeInterestFactory.matchesAny(text)");
        Set<String> set = prescanMap;
        synchronized (set) {
            if (prescanMap.isEmpty()) {
                for (PatternAndLocation patternKey : patternsBySource.values()) {
                    String pattern = patternKey.rewritePattern;
                    pattern = TypeInterestFactory.replaceRegexWithDot(pattern);
                    StringTokenizer stk = new StringTokenizer(pattern, ".");
                    while (stk.hasMoreTokens()) {
                        prescanMap.add(stk.nextToken());
                    }
                }
            }
        }
        StringTokenizer stk = new StringTokenizer(text, ".");
        boolean foundPotentialMatch = false;
        totalPrescans.incrementAndGet();
        while (stk.hasMoreTokens()) {
            if (!prescanMap.contains(stk.nextToken())) continue;
            foundPotentialMatch = true;
            break;
        }
        if (totalPrescans.get() % 25000 == 0) {
            int perc = (int)((double)totalPrescanHits.get() / (double)totalPrescans.get() * 100.0);
            LOG.fine("Prescan hit ratio " + totalPrescanHits.get() + " / " + totalPrescans.get() + "; " + perc + "%");
        }
        if (!foundPotentialMatch) {
            totalPrescanHits.incrementAndGet();
            return false;
        }
        try {
            block25: {
                boolean bl;
                if (ignorePatternSet.contains(text)) {
                    boolean perc = false;
                    return perc;
                }
                ExecutionStatistics.get().begin("TypeInterestFactory.matchesAny(text).cacheCheck");
                try {
                    Boolean cachedResult = TypeInterestFactory.checkCacheForMatches(text, typeReferenceLocation);
                    if (cachedResult != null) {
                        boolean bl2 = cachedResult;
                        return bl2;
                    }
                }
                finally {
                    ExecutionStatistics.get().end("TypeInterestFactory.matchesAny(text).cacheCheck");
                }
                ExecutionStatistics.get().begin("TypeInterestFactory.matchesAny(text).manualSearch");
                try {
                    if (!TypeInterestFactory.getTrieByLocation(typeReferenceLocation).matches(text)) break block25;
                    resultsCache.put(text, true);
                    bl = true;
                }
                catch (Throwable throwable) {
                    ExecutionStatistics.get().end("TypeInterestFactory.matchesAny(text).manualSearch");
                    throw throwable;
                }
                ExecutionStatistics.get().end("TypeInterestFactory.matchesAny(text).manualSearch");
                return bl;
            }
            resultsCache.put(TypeInterestFactory.getCacheKey(typeReferenceLocation, text), false);
            boolean bl = false;
            ExecutionStatistics.get().end("TypeInterestFactory.matchesAny(text).manualSearch");
            return bl;
        }
        finally {
            ExecutionStatistics.get().end("TypeInterestFactory.matchesAny(text)");
        }
    }

    private static String replaceRegexWithDot(String input) {
        return input.replaceAll("\\{.*\\}", ".");
    }

    static {
        ignorePatternSet.add("void");
        ignorePatternSet.add("String");
        ignorePatternSet.add("java.lang.String");
        ignorePatternSet.add("boolean");
        ignorePatternSet.add("Boolean");
        ignorePatternSet.add("java.lang.Boolean");
        ignorePatternSet.add("int");
        ignorePatternSet.add("Integer");
        ignorePatternSet.add("java.lang.Integer");
        ignorePatternSet.add("long");
        ignorePatternSet.add("Long");
        ignorePatternSet.add("java.lang.Long");
        ignorePatternSet.add("double");
        ignorePatternSet.add("Double");
        ignorePatternSet.add("java.lang.Double");
        ignorePatternSet.add("float");
        ignorePatternSet.add("Float");
        ignorePatternSet.add("java.lang.Float");
        resultsCache = Collections.synchronizedMap(new LRUMap(8000));
        cacheLookupCount = new AtomicLong(0L);
        cacheHitCount = new AtomicLong(0L);
        prescanMap = new TreeSet<String>();
        totalPrescans = new AtomicInteger();
        totalPrescanHits = new AtomicInteger();
    }

    private static class PatternAndLocation {
        private TypeReferenceLocation[] locations;
        private String regex;
        private String rewritePattern;

        private PatternAndLocation(TypeReferenceLocation[] locations, String regex, String rewritePattern) {
            this.locations = locations;
            this.regex = regex;
            this.rewritePattern = rewritePattern;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.locations);
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternAndLocation other = (PatternAndLocation)obj;
            if (!Arrays.equals(this.locations, other.locations)) {
                return false;
            }
            return !(this.regex == null ? other.regex != null : !this.regex.equals(other.regex));
        }
    }
}

