/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ArchiveType;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ConfigureArchiveTypes
extends AbstractIterationOperation<ArchiveModel> {
    private GraphTypeManager graphTypeManager;
    private HashMap<String, Class<? extends WindupVertexFrame>> suffixToModelClass = new HashMap();

    public ConfigureArchiveTypes(String variableName, GraphTypeManager graphTypeManager) {
        super(variableName);
        this.graphTypeManager = graphTypeManager;
        this.initTypes();
    }

    public ConfigureArchiveTypes(GraphTypeManager graphTypeManager) {
        this.graphTypeManager = graphTypeManager;
        this.initTypes();
    }

    public static ConfigureArchiveTypes forVar(String variableName, GraphTypeManager graphTypeManager) {
        return new ConfigureArchiveTypes(variableName, graphTypeManager);
    }

    public static ConfigureArchiveTypes withTypeManager(GraphTypeManager graphTypeManager) {
        return new ConfigureArchiveTypes(graphTypeManager);
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel archiveModel) {
        GraphContext graphContext = event.getGraphContext();
        String filename = archiveModel.getArchiveName();
        WindupVertexFrame newFrame = null;
        for (Map.Entry<String, Class<? extends WindupVertexFrame>> entry : this.suffixToModelClass.entrySet()) {
            if (!StringUtils.endsWith((String)filename, (String)entry.getKey())) continue;
            newFrame = GraphService.addTypeToModel((GraphContext)graphContext, (WindupVertexFrame)archiveModel, entry.getValue());
        }
        if (newFrame != null) {
            Iteration.setCurrentPayload((Variables)Variables.instance((GraphRewrite)event), (String)this.getVariableName(), newFrame);
        }
    }

    private void initTypes() {
        Set frameClasses = this.graphTypeManager.getRegisteredTypes();
        for (Class frameClass : frameClasses) {
            ArchiveType archiveType = frameClass.getAnnotation(ArchiveType.class);
            if (archiveType == null) continue;
            this.suffixToModelClass.put(archiveType.value(), frameClass);
        }
    }

    public String toString() {
        return "ConfigureArchiveTypes";
    }
}

