/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.lock;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.impl.lock.DeadlockError;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.util.Assert;

public class LockManagerImpl
implements LockManager {
    private ReentrantReadWriteLock readWriteLock;

    private synchronized Lock obtainLock(LockMode mode) {
        if (this.readWriteLock == null) {
            this.readWriteLock = new ReentrantReadWriteLock(true);
        }
        if (LockMode.READ.equals((Object)mode)) {
            return this.readWriteLock.readLock();
        }
        if (this.readWriteLock.getReadHoldCount() > 0) {
            throw new DeadlockError("Thread with READ lock attempted to obtain a WRITE lock (This is never allowed.)");
        }
        return this.readWriteLock.writeLock();
    }

    public <T> T performLocked(LockMode mode, Callable<T> task) {
        T result;
        Assert.notNull((Object)mode, (String)"LockMode must not be null.");
        Assert.notNull(task, (String)"Task to perform must not be null.");
        Lock lock = this.obtainLock(mode);
        lock.lock();
        try {
            result = task.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContainerException("Failed to execute task in LockMode [" + mode + "]", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return result;
    }
}

