/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.convert.impl;

import java.lang.reflect.Constructor;
import javax.enterprise.inject.Vetoed;
import org.jboss.forge.addon.convert.AbstractConverter;
import org.jboss.forge.addon.convert.exception.ConversionException;

@Vetoed
public class ConstructorConverter<SOURCETYPE, TARGETTYPE>
extends AbstractConverter<SOURCETYPE, TARGETTYPE> {
    private final Constructor<TARGETTYPE> constructor;

    public ConstructorConverter(Class<SOURCETYPE> sourceType, Class<TARGETTYPE> targetType, Constructor<TARGETTYPE> constructor) {
        super(sourceType, targetType);
        this.constructor = constructor;
    }

    public TARGETTYPE convert(SOURCETYPE source) {
        try {
            return this.constructor.newInstance(source);
        }
        catch (Exception e) {
            throw new ConversionException("Could not convert [" + source + "] to type [" + this.getTargetType() + "]", (Throwable)e);
        }
    }
}

